/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.xsl;

import java.net.URI;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import se.unlogic.standardutils.xsl.BaseXSLTransformer;
import se.unlogic.standardutils.xsl.TemplateCache;
import se.unlogic.standardutils.xsl.TemplateDescriptor;

public class URIXSLTransformer
extends BaseXSLTransformer {
    private final URI uri;
    private final URIResolver uriResolver;
    private final boolean useCache;

    public URIXSLTransformer(URI uri, boolean useCache) throws TransformerConfigurationException {
        this.uri = uri;
        this.uriResolver = null;
        this.useCache = useCache;
        this.reloadStyleSheet();
    }

    public URIXSLTransformer(URI uri, URIResolver uriResolver, boolean useCache) throws TransformerConfigurationException {
        this.uri = uri;
        this.uriResolver = uriResolver;
        this.useCache = useCache;
        this.reloadStyleSheet();
    }

    @Override
    public void reloadStyleSheet() throws TransformerConfigurationException {
        if (this.useCache) {
            this.templates = TemplateCache.getTemplates(new TemplateDescriptor(this.uri, this.uriResolver));
        } else {
            TransformerFactory transFact = TransformerFactory.newInstance();
            if (this.uriResolver != null) {
                transFact.setURIResolver(this.uriResolver);
            }
            this.templates = transFact.newTemplates(new StreamSource(this.uri.toString()));
        }
    }

    public String toString() {
        return "CachedXSLTURI: " + this.uri;
    }
}

