/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.xsl;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import se.unlogic.standardutils.xsl.TemplateDescriptor;

public class TemplateCache {
    private static final ReferenceQueue<Templates> REFERENCE_QUEUE = new ReferenceQueue();
    private static final ConcurrentHashMap<TemplateDescriptor, ValueReference> CACHE_MAP = new ConcurrentHashMap();

    public static Templates getTemplates(TemplateDescriptor descriptor) throws TransformerConfigurationException {
        Templates templates;
        TemplateCache.processReferenceQueue();
        ValueReference templateReference = CACHE_MAP.get(descriptor);
        if (templateReference != null && (templates = (Templates)templateReference.get()) != null) {
            return templates;
        }
        TransformerFactory transFact = TransformerFactory.newInstance();
        if (descriptor.getUriResolver() != null) {
            transFact.setURIResolver(descriptor.getUriResolver());
        }
        if ((templates = transFact.newTemplates(new StreamSource(descriptor.getUri().toString()))) == null) {
            throw new TransformerConfigurationException("Unable to cache template " + descriptor.getUri().toString());
        }
        CACHE_MAP.put(descriptor, new ValueReference(descriptor, templates, REFERENCE_QUEUE));
        return templates;
    }

    private static void processReferenceQueue() {
        Reference<Templates> reference;
        while ((reference = REFERENCE_QUEUE.poll()) != null) {
            TemplateDescriptor descriptor = ((ValueReference)reference).getDescriptor();
            CACHE_MAP.remove(descriptor);
        }
    }

    private static final class ValueReference
    extends WeakReference<Templates> {
        private final TemplateDescriptor descriptor;

        public ValueReference(TemplateDescriptor descriptor, Templates templates, ReferenceQueue<? super Templates> queue) {
            super(templates, queue);
            this.descriptor = descriptor;
        }

        public TemplateDescriptor getDescriptor() {
            return this.descriptor;
        }
    }
}

