/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.xsl;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import se.unlogic.standardutils.xsl.BaseXSLTransformer;

public class ResourceStreamXSLTransformer
extends BaseXSLTransformer {
    private Class<?> resourceClass;
    private String path;

    public ResourceStreamXSLTransformer(Class<?> resourceClass, String path) throws TransformerConfigurationException {
        this.cacheStyleSheet(resourceClass, path);
    }

    @Override
    public void reloadStyleSheet() throws TransformerConfigurationException {
        this.cacheStyleSheet(this.resourceClass, this.path);
    }

    private void cacheStyleSheet(Class<?> resourceClass, String path) throws TransformerConfigurationException {
        InputStream inputStream = resourceClass.getResourceAsStream(path);
        StreamSource xsltSource = new StreamSource(inputStream);
        TransformerFactory transFact = TransformerFactory.newInstance();
        Templates templates = transFact.newTemplates(xsltSource);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.templates = templates;
        this.resourceClass = resourceClass;
        this.path = path;
    }

    public String toString() {
        return "CachedXSLTResourceStream: " + this.resourceClass + " " + this.path;
    }
}

