/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.xml;

import java.util.ArrayList;
import java.util.List;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLParser;
import se.unlogic.standardutils.xml.XMLParserPopulateable;

public class XMLPopulationUtils {
    public static <T extends XMLParserPopulateable> List<T> populateBeans(XMLParser xmlParser, String path, Class<T> clazz, List<ValidationError> errors) {
        List<XMLParser> matchingElements = xmlParser.getNodes(path);
        if (matchingElements != null) {
            ArrayList<XMLParserPopulateable> beans = new ArrayList<XMLParserPopulateable>(matchingElements.size());
            for (XMLParser parser : matchingElements) {
                XMLParserPopulateable bean = (XMLParserPopulateable)ReflectionUtils.getInstance(clazz);
                try {
                    bean.populate(parser);
                    beans.add(bean);
                }
                catch (ValidationException e) {
                    errors.addAll(e.getErrors());
                }
            }
            if (!beans.isEmpty()) {
                return beans;
            }
        }
        return null;
    }

    public static <T extends XMLParserPopulateable> T populateBean(XMLParser xmlParser, String path, Class<T> clazz, List<ValidationError> errors) {
        XMLParser matchingElement = xmlParser.getNode(path);
        if (matchingElement != null) {
            XMLParserPopulateable bean = (XMLParserPopulateable)ReflectionUtils.getInstance(clazz);
            try {
                bean.populate(matchingElement);
                return (T)bean;
            }
            catch (ValidationException e) {
                errors.addAll(e.getErrors());
            }
        }
        return null;
    }
}

