/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.xml;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.standardutils.annotations.NoAnnotatedFieldsFoundException;
import se.unlogic.standardutils.arrays.ArrayUtils;
import se.unlogic.standardutils.date.DateUtils;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.string.DummyStringyfier;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.string.Stringyfier;
import se.unlogic.standardutils.xml.ClassXMLInfo;
import se.unlogic.standardutils.xml.Elementable;
import se.unlogic.standardutils.xml.ElementableListener;
import se.unlogic.standardutils.xml.FieldType;
import se.unlogic.standardutils.xml.FieldXMLInfo;
import se.unlogic.standardutils.xml.MissingXMLAnnotationException;
import se.unlogic.standardutils.xml.XMLAttribute;
import se.unlogic.standardutils.xml.XMLElement;
import se.unlogic.standardutils.xml.XMLGeneratorDocument;
import se.unlogic.standardutils.xml.XMLUtils;

public class XMLGenerator {
    private static ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static ReentrantReadWriteLock.ReadLock readLock = readWriteLock.readLock();
    private static ReentrantReadWriteLock.WriteLock writeLock = readWriteLock.writeLock();
    private static WeakHashMap<Class<?>, ClassXMLInfo> FIELD_MAP = new WeakHashMap();

    public static Element toXML(Object bean, Document doc) {
        ClassXMLInfo classInfo = XMLGenerator.getClassInfo(bean.getClass());
        Element classElement = doc.createElement(classInfo.getElementName());
        XMLGeneratorDocument generatorDocument = doc instanceof XMLGeneratorDocument ? (XMLGeneratorDocument)doc : null;
        for (FieldXMLInfo fieldInfo : classInfo.getFields()) {
            Element subElement;
            Object[] fieldValues;
            Object fieldValue;
            if (generatorDocument != null && generatorDocument.isIgnoredField(fieldInfo.getField())) continue;
            try {
                fieldValue = fieldInfo.getField().get(bean);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (fieldValue == null) continue;
            if (!fieldInfo.isList() && fieldInfo.getValueFormatter() != null) {
                fieldValue = fieldInfo.getValueFormatter().format(fieldValue);
            } else if (fieldValue instanceof Date) {
                fieldValue = DateUtils.DATE_TIME_FORMATTER.format((Date)fieldValue);
            }
            if (fieldInfo.getFieldType() == FieldType.ATTRIBUTE) {
                classElement.setAttribute(fieldInfo.getName(), fieldValue.toString());
                continue;
            }
            if (fieldInfo.isList()) {
                fieldValues = (Object[])fieldValue;
                if (fieldValues.isEmpty()) continue;
                subElement = fieldInfo.skipSubElement() ? classElement : doc.createElement(fieldInfo.getName());
                for (Object e : fieldValues) {
                    if (e == null) continue;
                    XMLGenerator.parseValue(fieldInfo, e, subElement, doc, generatorDocument);
                }
                if (fieldInfo.skipSubElement() || !subElement.hasChildNodes()) continue;
                classElement.appendChild(subElement);
                continue;
            }
            if (fieldInfo.isArray()) {
                fieldValues = (Object[])fieldValue;
                if (ArrayUtils.isEmpty(fieldValues)) continue;
                subElement = fieldInfo.skipSubElement() ? classElement : doc.createElement(fieldInfo.getName());
                for (Object value : fieldValues) {
                    if (value == null) continue;
                    XMLGenerator.parseValue(fieldInfo, value, subElement, doc, generatorDocument);
                }
                if (fieldInfo.skipSubElement() || !subElement.hasChildNodes()) continue;
                classElement.appendChild(subElement);
                continue;
            }
            if (fieldInfo.isElementable()) {
                Element subElement2 = ((Elementable)fieldValue).toXML(doc);
                if (subElement2 == null) continue;
                if (fieldInfo.getName() != null) {
                    subElement2 = (Element)doc.renameNode(subElement2, null, fieldInfo.getName());
                }
                if (fieldInfo.getChildName() != null) {
                    Element middleElement = doc.createElement(fieldInfo.getChildName());
                    classElement.appendChild(middleElement);
                    middleElement.appendChild(subElement2);
                } else {
                    classElement.appendChild(subElement2);
                }
                XMLGenerator.triggerElementableListener(generatorDocument, subElement2, fieldValue);
                continue;
            }
            if (fieldInfo.isCDATA()) {
                classElement.appendChild(XMLUtils.createCDATAElement(fieldInfo.getName(), fieldValue.toString(), doc));
                continue;
            }
            classElement.appendChild(XMLUtils.createElement(fieldInfo.getName(), fieldValue.toString(), doc));
        }
        return classElement;
    }

    public static String getElementName(Class<?> clazz) {
        return XMLGenerator.getClassInfo(clazz).getElementName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassXMLInfo getClassInfo(Class<?> clazz) {
        ClassXMLInfo classInfo = null;
        try {
            readLock.lock();
            classInfo = FIELD_MAP.get(clazz);
        }
        finally {
            readLock.unlock();
        }
        if (classInfo != null) {
            return classInfo;
        }
        XMLElement xmlElement = clazz.getAnnotation(XMLElement.class);
        if (xmlElement == null) {
            throw new MissingXMLAnnotationException(clazz);
        }
        String elementName = xmlElement.name();
        if (StringUtils.isEmpty(elementName)) {
            elementName = clazz.getSimpleName();
        }
        if (xmlElement.fixCase()) {
            elementName = StringUtils.toFirstLetterUppercase(elementName);
        }
        ArrayList<FieldXMLInfo> annotatedFields = new ArrayList<FieldXMLInfo>();
        for (Class<?> currentClazz = clazz; currentClazz != Object.class; currentClazz = currentClazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = currentClazz.getDeclaredFields()) {
                XMLAttribute attributeAnnotation;
                XMLElement elementAnnotation = field.getAnnotation(XMLElement.class);
                if (elementAnnotation != null) {
                    String childName;
                    boolean elementable;
                    String name = elementAnnotation.name();
                    if (StringUtils.isEmpty(name)) {
                        name = field.getName();
                        if (elementAnnotation.fixCase()) {
                            name = StringUtils.toFirstLetterUppercase(name);
                        }
                    }
                    Stringyfier valueFormatter = null;
                    if (elementAnnotation.valueFormatter() != DummyStringyfier.class) {
                        try {
                            valueFormatter = elementAnnotation.valueFormatter().newInstance();
                        }
                        catch (InstantiationException e) {
                            throw new RuntimeException(e);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (Collection.class.isAssignableFrom(field.getType())) {
                        elementable = false;
                        if (ReflectionUtils.isGenericlyTyped(field) && Elementable.class.isAssignableFrom((Class)ReflectionUtils.getGenericType(field))) {
                            elementable = true;
                        }
                        if (StringUtils.isEmpty(childName = elementAnnotation.childName())) {
                            childName = "value";
                        }
                        annotatedFields.add(new FieldXMLInfo(name, field, FieldType.ELEMENT, elementAnnotation.cdata(), elementable, true, false, childName, elementAnnotation.skipChildParentElement(), valueFormatter));
                    } else if (field.getType().isArray()) {
                        elementable = false;
                        if (Elementable.class.isAssignableFrom(field.getType())) {
                            elementable = true;
                        }
                        if (StringUtils.isEmpty(childName = elementAnnotation.childName())) {
                            childName = "value";
                        }
                        annotatedFields.add(new FieldXMLInfo(name, field, FieldType.ELEMENT, elementAnnotation.cdata(), elementable, false, true, childName, elementAnnotation.skipChildParentElement(), valueFormatter));
                    } else {
                        elementable = Elementable.class.isAssignableFrom(field.getType());
                        childName = null;
                        if (!StringUtils.isEmpty(elementAnnotation.childName())) {
                            childName = elementAnnotation.childName();
                        }
                        if (elementable && StringUtils.isEmpty(elementAnnotation.name())) {
                            name = null;
                        }
                        annotatedFields.add(new FieldXMLInfo(name, field, FieldType.ELEMENT, elementAnnotation.cdata(), elementable, false, false, childName, false, valueFormatter));
                    }
                    ReflectionUtils.fixFieldAccess(field);
                }
                if ((attributeAnnotation = field.getAnnotation(XMLAttribute.class)) == null) continue;
                String name = attributeAnnotation.name();
                if (StringUtils.isEmpty(name)) {
                    name = field.getName();
                }
                Stringyfier valueFormatter = null;
                if (attributeAnnotation.valueFormatter() != DummyStringyfier.class) {
                    try {
                        valueFormatter = attributeAnnotation.valueFormatter().newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                annotatedFields.add(new FieldXMLInfo(name, field, FieldType.ATTRIBUTE, false, false, false, false, null, false, valueFormatter));
                ReflectionUtils.fixFieldAccess(field);
            }
        }
        if (annotatedFields.isEmpty()) {
            throw new NoAnnotatedFieldsFoundException(clazz, XMLElement.class, XMLAttribute.class);
        }
        classInfo = new ClassXMLInfo(elementName, annotatedFields);
        try {
            writeLock.lock();
            FIELD_MAP.put(clazz, classInfo);
        }
        finally {
            writeLock.unlock();
        }
        return classInfo;
    }

    private static void triggerElementableListener(XMLGeneratorDocument doc, Element subElement, Object fieldValue) {
        ElementableListener<?> elementableListener;
        if (doc != null && (elementableListener = doc.getElementableListener(fieldValue.getClass())) != null) {
            elementableListener.elementGenerated(doc.getDocument(), subElement, fieldValue);
        }
    }

    private static void parseValue(FieldXMLInfo fieldInfo, Object value, Element subElement, Document doc, XMLGeneratorDocument generatorDocument) {
        if (fieldInfo.getValueFormatter() != null) {
            value = fieldInfo.getValueFormatter().format(value);
        } else if (value instanceof Date) {
            value = DateUtils.DATE_TIME_FORMATTER.format((Date)value);
        }
        if (fieldInfo.isElementable()) {
            Element subSubElement = ((Elementable)value).toXML(doc);
            if (subSubElement != null) {
                subElement.appendChild(subSubElement);
            }
            XMLGenerator.triggerElementableListener(generatorDocument, subSubElement, value);
        } else if (fieldInfo.isCDATA()) {
            subElement.appendChild(XMLUtils.createCDATAElement(fieldInfo.getChildName(), value, doc));
        } else {
            subElement.appendChild(XMLUtils.createElement(fieldInfo.getChildName(), value, doc));
        }
    }
}

