/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.validation;

import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.xml.Elementable;

public class ValidationException
extends Exception
implements Elementable {
    private static final long serialVersionUID = -1221745166857804542L;
    private final List<ValidationError> errors;

    public ValidationException(List<ValidationError> errors) {
        if (errors == null) {
            throw new NullPointerException();
        }
        this.errors = errors;
    }

    public ValidationException(ValidationError ... errors) {
        if (errors == null) {
            throw new NullPointerException();
        }
        this.errors = Arrays.asList(errors);
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }

    @Override
    public final Element toXML(Document doc) {
        Element validationException = doc.createElement("validationException");
        for (ValidationError validationError : this.errors) {
            if (validationError == null) continue;
            validationException.appendChild(validationError.toXML(doc));
        }
        return validationException;
    }

    @Override
    public String toString() {
        return "ValidationException [errors=" + this.errors + "]";
    }
}

