/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.validation;

import se.unlogic.standardutils.validation.ValidationErrorType;
import se.unlogic.standardutils.xml.GeneratedElementable;
import se.unlogic.standardutils.xml.XMLElement;

@XMLElement(name="validationError")
public class ValidationError
extends GeneratedElementable {
    @XMLElement
    private final String fieldName;
    @XMLElement
    private final String displayName;
    @XMLElement
    private final ValidationErrorType validationErrorType;
    @XMLElement
    private final String messageKey;

    public ValidationError(String fieldName, ValidationErrorType validationErrorType, String messageKey) {
        this.fieldName = fieldName;
        this.validationErrorType = validationErrorType;
        this.messageKey = messageKey;
        this.displayName = null;
    }

    public ValidationError(String fieldName, ValidationErrorType validationErrorType) {
        this.fieldName = fieldName;
        this.validationErrorType = validationErrorType;
        this.displayName = null;
        this.messageKey = null;
    }

    public ValidationError(String fieldName, String displayName, ValidationErrorType validationErrorType) {
        this.fieldName = fieldName;
        this.displayName = displayName;
        this.validationErrorType = validationErrorType;
        this.messageKey = null;
    }

    public ValidationError(String messageKey) {
        this.fieldName = null;
        this.displayName = null;
        this.validationErrorType = null;
        this.messageKey = messageKey;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public ValidationErrorType getValidationErrorType() {
        return this.validationErrorType;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public String toString() {
        return "ValidationError [" + (this.fieldName != null ? "fieldName=" + this.fieldName + ", " : "") + (this.validationErrorType != null ? "validationErrorType=" + (Object)((Object)this.validationErrorType) + ", " : "") + (this.messageKey != null ? "messageKey=" + this.messageKey : "") + "]";
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        result = 31 * result + (this.messageKey == null ? 0 : this.messageKey.hashCode());
        result = 31 * result + (this.validationErrorType == null ? 0 : this.validationErrorType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidationError other = (ValidationError)obj;
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
            return false;
        }
        if (this.messageKey == null ? other.messageKey != null : !this.messageKey.equals(other.messageKey)) {
            return false;
        }
        return this.validationErrorType == other.validationErrorType;
    }
}

