/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.validation;

import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.validation.StringNumberValidator;

public class StringDoubleValidator
extends StringNumberValidator<Double> {
    public StringDoubleValidator() {
        super(null, null);
    }

    public StringDoubleValidator(Double minValue, Double maxValue) {
        super(minValue, maxValue);
    }

    @Override
    public boolean validateFormat(String value) {
        Double numberValue = NumberUtils.toDouble(value);
        if (numberValue == null) {
            return false;
        }
        if (this.maxValue != null && this.minValue != null) {
            return numberValue <= (Double)this.maxValue && numberValue > (Double)this.minValue;
        }
        if (this.maxValue != null) {
            return numberValue <= (Double)this.maxValue;
        }
        if (this.minValue != null) {
            return numberValue >= (Double)this.minValue;
        }
        return true;
    }
}

