/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.time;

import java.sql.Timestamp;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import se.unlogic.standardutils.date.PooledSimpleDateFormat;

public class TimeUtils {
    public static PooledSimpleDateFormat HOUR_FORMATTER = new PooledSimpleDateFormat("HH");
    public static PooledSimpleDateFormat MINUTE_FORMATTER = new PooledSimpleDateFormat("mm");
    public static PooledSimpleDateFormat SECOND_FORMATTER = new PooledSimpleDateFormat("ss");
    public static PooledSimpleDateFormat TIME_FORMATTER = new PooledSimpleDateFormat("HH:mm");
    public static PooledSimpleDateFormat TIME_SECONDS_FORMATTER = new PooledSimpleDateFormat("HH:mm:ss");

    public static String secondsToString(long time) {
        return TimeUtils.millisecondsToString(time * 1000L);
    }

    public static String millisecondsToString(long time) {
        int milliseconds = (int)(time % 1000L);
        int seconds = (int)(time / 1000L % 60L);
        int minutes = (int)(time / 60000L % 60L);
        int hours = (int)(time / 3600000L % 24L);
        String millisecondsStr = (milliseconds < 10 ? "00" : (milliseconds < 100 ? "0" : "")) + milliseconds;
        String secondsStr = (seconds < 10 ? "0" : "") + seconds;
        String minutesStr = (minutes < 10 ? "0" : "") + minutes;
        String hoursStr = (hours < 10 ? "0" : "") + hours;
        return new String(hoursStr + ":" + minutesStr + ":" + secondsStr + "." + millisecondsStr);
    }

    public static String millisecondsToShortString(long time) {
        int minutes = (int)(time / 60000L % 60L);
        int hours = (int)(time / 3600000L % 24L);
        String minutesStr = (minutes < 10 ? "0" : "") + minutes;
        String hoursStr = (hours < 10 ? "0" : "") + hours;
        return new String(hoursStr + ":" + minutesStr);
    }

    public static int getMinutes(long time) {
        return Integer.valueOf(MINUTE_FORMATTER.format(new Date(time)));
    }

    public static int getSeconds(long time) {
        return Integer.valueOf(SECOND_FORMATTER.format(new Date(time)));
    }

    public static int getHour(long time) {
        return Integer.valueOf(HOUR_FORMATTER.format(new Date(time)));
    }

    public static String hourAndMinutesToString(int hours, int minutes) {
        String minutesStr = (minutes < 10 ? "0" : "") + minutes;
        String hoursStr = (hours < 10 ? "0" : "") + hours;
        return new String(hoursStr + ":" + minutesStr);
    }

    public static Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Timestamp getTimeStamp(XMLGregorianCalendar xmlCalendar) {
        if (xmlCalendar == null) {
            return null;
        }
        return new Timestamp(xmlCalendar.toGregorianCalendar().getTimeInMillis());
    }
}

