/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.threads;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import se.unlogic.standardutils.reflection.ReflectionUtils;

public class ReflectedRunnable
implements Runnable {
    private final Object object;
    private final Method method;

    public ReflectedRunnable(Object object, String methodName) {
        this.object = object;
        this.method = ReflectionUtils.getMethod(object.getClass(), methodName, 0);
        if (this.method == null) {
            throw new RuntimeException("Method " + methodName + "() not found in class " + object.getClass());
        }
        if (!this.method.isAccessible()) {
            ReflectionUtils.fixMethodAccess(this.method);
        }
    }

    @Override
    public void run() {
        try {
            this.method.invoke(this.object, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

