/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.text;

import java.text.DecimalFormat;
import java.text.ParseException;
import se.unlogic.standardutils.pool.GenericObjectPool;
import se.unlogic.standardutils.text.DecimalFormatFactory;

public class PooledDecimalFormat {
    protected GenericObjectPool<DecimalFormat> pool;
    DecimalFormat decimalFormat;

    public PooledDecimalFormat(String format) {
        this.pool = new GenericObjectPool<DecimalFormat>(new DecimalFormatFactory(format));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String format(long number) {
        DecimalFormat decimalFormat = null;
        try {
            decimalFormat = this.pool.borrowObject();
            String string = decimalFormat.format(number);
            return string;
        }
        finally {
            this.pool.returnObject(decimalFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String format(double number) {
        DecimalFormat decimalFormat = null;
        try {
            decimalFormat = this.pool.borrowObject();
            String string = decimalFormat.format(number);
            return string;
        }
        finally {
            this.pool.returnObject(decimalFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String format(Object number) {
        DecimalFormat decimalFormat = null;
        try {
            decimalFormat = this.pool.borrowObject();
            String string = decimalFormat.format(number);
            return string;
        }
        finally {
            this.pool.returnObject(decimalFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number parse(String source) throws ParseException {
        DecimalFormat decimalFormat = null;
        try {
            decimalFormat = this.pool.borrowObject();
            Number number = decimalFormat.parse(source);
            return number;
        }
        finally {
            this.pool.returnObject(decimalFormat);
        }
    }

    public int getObjectsCreated() {
        return this.pool.getObjectsCreated();
    }

    public int getObjectsInPool() {
        return this.pool.getObjectsInPool();
    }
}

