/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.string;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import se.unlogic.standardutils.datatypes.SimpleEntry;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.string.BeanTagSource;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.string.Stringyfier;
import se.unlogic.standardutils.string.TagSourceFactory;

public class BeanTagSourceFactory<T>
implements TagSourceFactory<T> {
    private Class<T> beanClass;
    private HashMap<String, Map.Entry<Method, Stringyfier>> tagMethodMap = new HashMap();
    private HashMap<String, Map.Entry<Field, Stringyfier>> tagFieldMap = new HashMap();
    private HashSet<String> tagsSet = new HashSet();

    public BeanTagSourceFactory(Class<T> beanClass) {
        this.beanClass = beanClass;
    }

    public void addMethodMapping(String tag, String methodName) throws NoSuchMethodException {
        this.addMethodMapping(tag, methodName, null);
    }

    public void addMethodMapping(String tag, String methodName, Stringyfier stringyfier) throws NoSuchMethodException {
        Method method = ReflectionUtils.getMethod(this.beanClass, methodName, Object.class, new Class[0]);
        if (method == null) {
            throw new NoSuchMethodException("Method " + methodName + " with no input parameters not found in " + this.beanClass);
        }
        this.addMethodMapping(tag, method, stringyfier);
    }

    protected void addMethodMapping(String tag, Method method, Stringyfier stringyfier) {
        if (!method.isAccessible()) {
            ReflectionUtils.fixMethodAccess(method);
        }
        this.tagMethodMap.put(tag, new SimpleEntry<Method, Stringyfier>(method, stringyfier));
        this.tagsSet.add(tag);
    }

    public void addFieldMapping(String tag, String fieldName) throws NoSuchFieldException {
        this.addFieldMapping(tag, fieldName, null);
    }

    public void addFieldMapping(String tag, String fieldName, Stringyfier stringyfier) throws NoSuchFieldException {
        Field field = ReflectionUtils.getField(this.beanClass, fieldName);
        if (field == null) {
            throw new NoSuchFieldException("Field " + fieldName + " not found in " + this.beanClass);
        }
        this.addFieldMapping(tag, field, stringyfier);
    }

    protected void addFieldMapping(String tag, Field field, Stringyfier stringyfier) {
        if (!field.isAccessible()) {
            ReflectionUtils.fixFieldAccess(field);
        }
        this.tagFieldMap.put(tag, new SimpleEntry<Field, Stringyfier>(field, stringyfier));
        this.tagsSet.add(tag);
    }

    public void addAllFields(String fieldPrefix, String ... excludedFields) {
        List<String> exclusionList = null;
        if (excludedFields != null) {
            exclusionList = Arrays.asList(excludedFields);
        }
        List<Field> fields = ReflectionUtils.getFields(this.beanClass);
        for (Field field : fields) {
            if (exclusionList != null && exclusionList.contains(field.getName())) continue;
            if (!field.isAccessible()) {
                ReflectionUtils.fixFieldAccess(field);
            }
            this.tagFieldMap.put(fieldPrefix + field.getName(), new SimpleEntry<Field, Object>(field, null));
            this.tagsSet.add(fieldPrefix + field.getName());
        }
    }

    @Override
    public <X extends T> BeanTagSource<T> getTagSource(X bean) {
        return new BeanTagSource<X>(bean, this.tagMethodMap, this.tagFieldMap, this.tagsSet);
    }

    public HashSet<String> getTagsSet() {
        return new HashSet<String>(this.tagsSet);
    }

    @Override
    public String getAvailableTags() {
        return StringUtils.toCommaSeparatedString(this.tagsSet);
    }
}

