/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.string;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import se.unlogic.standardutils.string.Stringyfier;
import se.unlogic.standardutils.string.TagSource;

public class BeanTagSource<T>
implements TagSource {
    private final T bean;
    private final Set<String> tagSet;
    private final HashMap<String, Map.Entry<Method, Stringyfier>> tagMethodMap;
    private final HashMap<String, Map.Entry<Field, Stringyfier>> tagFieldMap;

    public BeanTagSource(T bean, HashMap<String, Map.Entry<Method, Stringyfier>> tagMethodMap, HashMap<String, Map.Entry<Field, Stringyfier>> tagFieldMap, Set<String> tagSet) {
        this.bean = bean;
        this.tagMethodMap = tagMethodMap;
        this.tagFieldMap = tagFieldMap;
        this.tagSet = tagSet;
    }

    @Override
    public String getTagValue(String tag) {
        Map.Entry<Field, Stringyfier> fieldEntry = this.tagFieldMap.get(tag);
        if (fieldEntry != null) {
            try {
                Object value = fieldEntry.getKey().get(this.bean);
                if (value != null) {
                    if (fieldEntry.getValue() != null) {
                        return fieldEntry.getValue().format(value);
                    }
                    return value.toString();
                }
                return null;
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        Map.Entry<Method, Stringyfier> methodEntry = this.tagMethodMap.get(tag);
        if (methodEntry != null) {
            try {
                Object value = methodEntry.getKey().invoke(this.bean, new Object[0]);
                if (value != null) {
                    if (methodEntry.getValue() != null) {
                        return methodEntry.getValue().format(value);
                    }
                    return value.toString();
                }
                return null;
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public Set<String> getTags() {
        return this.tagSet;
    }
}

