/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.string;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.string.BeanTagSourceFactory;
import se.unlogic.standardutils.string.DummyStringyfier;
import se.unlogic.standardutils.string.StringTag;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.string.Stringyfier;

public class AnnotatedBeanTagSourceFactory<T>
extends BeanTagSourceFactory<T> {
    public AnnotatedBeanTagSourceFactory(Class<T> beanClass, String defaultPrefix) {
        super(beanClass);
        List<Field> fields = ReflectionUtils.getFields(beanClass);
        for (Field field : fields) {
            StringTag stringTag = field.getAnnotation(StringTag.class);
            if (stringTag == null) continue;
            Stringyfier stringyfier = this.getStringfier(stringTag);
            if (StringUtils.isEmpty(stringTag.name())) {
                this.addFieldMapping(defaultPrefix + field.getName(), field, stringyfier);
                continue;
            }
            this.addFieldMapping(defaultPrefix + stringTag.name(), field, stringyfier);
        }
        List<Method> methods = ReflectionUtils.getMethods(beanClass);
        for (Method method : methods) {
            StringTag stringTag = method.getAnnotation(StringTag.class);
            if (stringTag == null) continue;
            Stringyfier stringyfier = this.getStringfier(stringTag);
            if (StringUtils.isEmpty(stringTag.name())) {
                this.addMethodMapping(defaultPrefix + method.getName(), method, stringyfier);
                continue;
            }
            this.addMethodMapping(defaultPrefix + stringTag.name(), method, stringyfier);
        }
    }

    private Stringyfier getStringfier(StringTag stringTag) {
        if (!stringTag.valueFormatter().equals(DummyStringyfier.class)) {
            try {
                return stringTag.valueFormatter().newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

