/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import se.unlogic.standardutils.streams.StreamUtils;

public class SerializationUtils {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T cloneSerializable(T obj) {
        Serializable serializable;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(obj);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            serializable = (Serializable)objectInputStream.readObject();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
                catch (ClassNotFoundException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(byteArrayOutputStream);
                StreamUtils.closeStream(objectOutputStream);
                StreamUtils.closeStream(byteArrayInputStream);
                StreamUtils.closeStream(objectInputStream);
                throw throwable;
            }
        }
        StreamUtils.closeStream(byteArrayOutputStream);
        StreamUtils.closeStream(objectOutputStream);
        StreamUtils.closeStream(byteArrayInputStream);
        StreamUtils.closeStream(objectInputStream);
        return (T)serializable;
    }

    public static byte[] serializeToArray(Serializable object) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(byteArrayOutputStream);
                StreamUtils.closeStream(objectOutputStream);
                throw throwable;
            }
        }
        StreamUtils.closeStream(byteArrayOutputStream);
        StreamUtils.closeStream(objectOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static <T> T deserializeFromArray(Class<T> clazz, byte[] bytes) {
        Object object;
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(bytes);
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(objectInputStream);
                StreamUtils.closeStream(byteArrayInputStream);
                throw throwable;
            }
        }
        StreamUtils.closeStream(objectInputStream);
        StreamUtils.closeStream(byteArrayInputStream);
        return (T)object;
    }
}

