/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.rss;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.standardutils.date.PooledSimpleDateFormat;
import se.unlogic.standardutils.rss.RSSChannel;
import se.unlogic.standardutils.rss.RSSItem;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.xml.XMLUtils;

public class RSSGenerator {
    public static final PooledSimpleDateFormat DATE_FORMATTER = new PooledSimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US, TimeZone.getTimeZone("GMT"));
    protected RSSChannel channel;
    protected int rssItemDescriptionMaxLength = 247;

    public RSSGenerator(RSSChannel channel) {
        this.setDescriptor(channel);
    }

    public RSSGenerator(RSSChannel channel, int rssItemDescriptionMaxLength) {
        this.setDescriptor(channel);
        this.rssItemDescriptionMaxLength = rssItemDescriptionMaxLength;
    }

    public RSSChannel getDescriptor() {
        return this.channel;
    }

    public void setDescriptor(RSSChannel channel) {
        if (channel == null) {
            throw new NullPointerException("RssDescriptor cannot be null");
        }
        this.channel = channel;
    }

    public Document getXmlRss(List<? extends RSSItem> items) {
        Document doc = XMLUtils.createDomDocument();
        Element rssElement = doc.createElement("rss");
        rssElement.setAttribute("version", "2.0");
        rssElement.setAttribute("xmlns:atom", "http://www.w3.org/2005/Atom");
        doc.appendChild(rssElement);
        Element channelElement = doc.createElement("channel");
        rssElement.appendChild(channelElement);
        Element atomLinkElement = doc.createElement("atom:link");
        atomLinkElement.setAttribute("href", this.channel.getFeedLink());
        atomLinkElement.setAttribute("rel", "self");
        atomLinkElement.setAttribute("type", "application/rss+xml");
        channelElement.appendChild(atomLinkElement);
        XMLUtils.appendNewElement(doc, channelElement, "title", this.channel.getTitle());
        XMLUtils.appendNewElement(doc, channelElement, "link", this.channel.getLink());
        XMLUtils.appendNewElement(doc, channelElement, "description", this.channel.getDescription());
        XMLUtils.appendNewElement(doc, channelElement, "ttl", this.channel.getTtl());
        XMLUtils.appendNewElement(doc, channelElement, "webMaster", this.channel.getWebmaster());
        XMLUtils.appendNewElement(doc, channelElement, "managingEditor", this.channel.getManagingEditor());
        XMLUtils.appendNewElement(doc, channelElement, "copyright", this.channel.getCopyright());
        if (this.channel.getLastBuildDate() != null) {
            XMLUtils.appendNewElement(doc, channelElement, "lastBuildDate", DATE_FORMATTER.format(this.channel.getLastBuildDate()));
        }
        if (this.channel.getPubDate() != null) {
            XMLUtils.appendNewElement(doc, channelElement, "pubDate", DATE_FORMATTER.format(this.channel.getPubDate()));
        }
        XMLUtils.appendNewElement(doc, channelElement, "language", this.channel.getLanguage());
        Collection<String> categories = this.channel.getCategories();
        if (categories != null) {
            for (String string : categories) {
                XMLUtils.appendNewElement(doc, channelElement, "category", string);
            }
        }
        if (items != null) {
            for (RSSItem rSSItem : items) {
                Element itemElement = doc.createElement("item");
                XMLUtils.appendNewElement(doc, itemElement, "title", rSSItem.getTitle());
                XMLUtils.appendNewElement(doc, itemElement, "link", rSSItem.getLink());
                String description = rSSItem.getDescription();
                if (this.rssItemDescriptionMaxLength > 0) {
                    description = StringUtils.substring(description, this.rssItemDescriptionMaxLength, "...");
                }
                XMLUtils.appendNewElement(doc, itemElement, "description", description);
                if (rSSItem.getPubDate() != null) {
                    XMLUtils.appendNewElement(doc, itemElement, "pubDate", DATE_FORMATTER.format(rSSItem.getPubDate()));
                }
                XMLUtils.appendNewElement(doc, itemElement, "guid", rSSItem.getLink());
                XMLUtils.appendNewElement(doc, itemElement, "comments", rSSItem.getCommentsLink());
                if (rSSItem.getAuthor() != null) {
                    XMLUtils.appendNewElement(doc, itemElement, "author", rSSItem.getAuthor());
                }
                if (rSSItem.getCategories() != null) {
                    for (String category : rSSItem.getCategories()) {
                        XMLUtils.appendNewElement(doc, itemElement, "category", category);
                    }
                }
                channelElement.appendChild(itemElement);
            }
        }
        return doc;
    }

    public String getStringRss(List<? extends RSSItem> items, String encoding) throws TransformerFactoryConfigurationError, TransformerException {
        return XMLUtils.toString(this.getXmlRss(items), "ISO-8859-1", true);
    }
}

