/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.populators;

import java.sql.Time;
import java.text.ParseException;
import java.util.Date;
import se.unlogic.standardutils.date.DateUtils;
import se.unlogic.standardutils.date.ThreadSafeDateFormat;
import se.unlogic.standardutils.populators.BaseStringPopulator;
import se.unlogic.standardutils.time.TimeUtils;
import se.unlogic.standardutils.validation.StringFormatValidator;

public class TimePopulator
extends BaseStringPopulator<Time> {
    private final ThreadSafeDateFormat dateFormat;

    public TimePopulator() {
        this.dateFormat = TimeUtils.TIME_FORMATTER;
    }

    public TimePopulator(ThreadSafeDateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public TimePopulator(String populatorID, ThreadSafeDateFormat dateFormat) {
        super(populatorID);
        this.dateFormat = dateFormat;
    }

    public TimePopulator(String populatorID, ThreadSafeDateFormat dateFormat, StringFormatValidator formatValidator) {
        super(populatorID, formatValidator);
        this.dateFormat = dateFormat;
    }

    @Override
    public Class<? extends Time> getType() {
        return Time.class;
    }

    @Override
    public Time getValue(String value) {
        try {
            Date utilDate = this.dateFormat.parse(value);
            return new Time(utilDate.getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean validateDefaultFormat(String value) {
        return DateUtils.isValidDate(this.dateFormat, value);
    }
}

