/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.populators;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.regex.Pattern;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.populators.BaseStringPopulator;
import se.unlogic.standardutils.populators.BeanStringPopulator;

public class SocialSecurityPopulator
extends BaseStringPopulator<String>
implements BeanResultSetPopulator<String>,
BeanStringPopulator<String> {
    Pattern pattern10 = Pattern.compile("[0-9]{6}[-+][0-9]{4}");
    Pattern pattern12 = Pattern.compile("(19|20)[0-9]{6}-[0-9]{4}");
    private static final SocialSecurityPopulator POPULATOR = new SocialSecurityPopulator();

    @Override
    public String populate(ResultSet rs) throws SQLException {
        return rs.getString(1);
    }

    public static SocialSecurityPopulator getPopulator() {
        return POPULATOR;
    }

    @Override
    public String getValue(String value) {
        return value;
    }

    @Override
    public boolean validateDefaultFormat(String value) {
        int year = Calendar.getInstance().get(1);
        if (!this.pattern12.matcher(value).matches()) {
            if (this.pattern10.matcher(value).matches()) {
                int currentCentury = year / 100;
                int currentDec = year % 100;
                int decennium = Integer.valueOf(value.substring(0, 2));
                if (decennium > currentDec) {
                    --currentCentury;
                }
                if (value.contains("+")) {
                    --currentCentury;
                    value = value.replace("+", "-");
                }
                value = Integer.toString(currentCentury) + value;
            } else {
                return false;
            }
        }
        if (Integer.valueOf(value.substring(0, 4)) > year) {
            return false;
        }
        return NumberUtils.isValidCC(this.format(value));
    }

    @Override
    public Class<? extends String> getType() {
        return String.class;
    }

    protected String format(String value) {
        String formattedValue = value.replace("-", "");
        if (formattedValue.length() == 12) {
            return formattedValue.substring(2);
        }
        return formattedValue;
    }

    public static void main(String[] args) {
        String[] ss = new String[]{"930924-8616", "19930924-8616", "20930924-8616", "930924+8616"};
        SocialSecurityPopulator ssp = new SocialSecurityPopulator();
        for (String s : ss) {
            System.out.println(s + " = " + ssp.validateDefaultFormat(s));
        }
    }
}

