/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.populators;

import java.sql.ResultSet;
import java.sql.SQLException;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.populators.BaseStringPopulator;
import se.unlogic.standardutils.validation.StringFormatValidator;

public class FloatPopulator
extends BaseStringPopulator<Float>
implements BeanResultSetPopulator<Float> {
    private static final FloatPopulator POPULATOR = new FloatPopulator();
    private int columnIndex = 1;

    public static FloatPopulator getPopulator() {
        return POPULATOR;
    }

    public FloatPopulator() {
    }

    public FloatPopulator(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public FloatPopulator(String populatorID, StringFormatValidator formatValidator) {
        super(populatorID, formatValidator);
    }

    public FloatPopulator(String populatorID) {
        super(populatorID);
    }

    @Override
    public Float populate(ResultSet rs) throws SQLException {
        return Float.valueOf(rs.getFloat(this.columnIndex));
    }

    @Override
    public Float getValue(String value) {
        return Float.valueOf(value);
    }

    @Override
    public boolean validateDefaultFormat(String value) {
        return NumberUtils.isFloat(value);
    }

    @Override
    public Class<? extends Float> getType() {
        return Float.class;
    }
}

