/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.populators;

import java.text.ParseException;
import java.util.Date;
import se.unlogic.standardutils.date.DateUtils;
import se.unlogic.standardutils.date.ThreadSafeDateFormat;
import se.unlogic.standardutils.populators.BaseStringPopulator;
import se.unlogic.standardutils.validation.StringFormatValidator;

public class DatePopulator
extends BaseStringPopulator<java.sql.Date> {
    private final ThreadSafeDateFormat dateFormat;

    public DatePopulator() {
        this.dateFormat = DateUtils.DATE_FORMATTER;
    }

    public DatePopulator(ThreadSafeDateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public DatePopulator(String populatorID, ThreadSafeDateFormat dateFormat) {
        super(populatorID);
        this.dateFormat = dateFormat;
    }

    public DatePopulator(String populatorID, ThreadSafeDateFormat dateFormat, StringFormatValidator formatValidator) {
        super(populatorID, formatValidator);
        this.dateFormat = dateFormat;
    }

    @Override
    public Class<? extends java.sql.Date> getType() {
        return java.sql.Date.class;
    }

    @Override
    public java.sql.Date getValue(String value) {
        try {
            Date utilDate = this.dateFormat.parse(value);
            return new java.sql.Date(utilDate.getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean validateDefaultFormat(String value) {
        return DateUtils.isValidDate(this.dateFormat, value);
    }
}

