/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.pool;

import java.util.ArrayList;
import java.util.List;
import se.unlogic.standardutils.factory.BeanFactory;
import se.unlogic.standardutils.pool.InvalidObjectException;
import se.unlogic.standardutils.pool.PoolExhaustedBehaviour;
import se.unlogic.standardutils.pool.PoolExhaustedException;
import se.unlogic.standardutils.pool.PoolFullException;

public class GenericObjectPool<T> {
    protected int minSize;
    protected int maxSize;
    protected int objectsCreated;
    protected BeanFactory<T> factory;
    protected List<T> pool;
    protected PoolExhaustedBehaviour poolExhaustedBehaviour;

    public GenericObjectPool(int minSize, int maxSize, BeanFactory<T> factory, PoolExhaustedBehaviour poolExhaustedBehaviour) {
        if (minSize > maxSize) {
            throw new RuntimeException("minSize cannot be bigger than maxSize");
        }
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.factory = factory;
        this.poolExhaustedBehaviour = poolExhaustedBehaviour;
        this.pool = this.createList();
        this.initializePool();
    }

    public GenericObjectPool(BeanFactory<T> factory) {
        this(0, 10, factory, PoolExhaustedBehaviour.GROW);
    }

    protected List<T> createList() {
        return new ArrayList(this.maxSize);
    }

    protected void initializePool() {
        if (this.minSize != 0) {
            while (this.pool.size() < this.minSize) {
                this.pool.add(this.factory.newInstance());
                ++this.objectsCreated;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T borrowObject() throws PoolExhaustedException {
        List<T> list = this.pool;
        synchronized (list) {
            T object = null;
            if (this.pool.isEmpty()) {
                if (this.poolExhaustedBehaviour == PoolExhaustedBehaviour.GROW) {
                    object = this.factory.newInstance();
                    ++this.objectsCreated;
                } else {
                    if (this.poolExhaustedBehaviour == PoolExhaustedBehaviour.THROW_EXCEPTION) {
                        throw new PoolExhaustedException("Pool has reached it's max size of " + this.maxSize + " objects");
                    }
                    if (this.poolExhaustedBehaviour == PoolExhaustedBehaviour.WAIT) {
                        try {
                            this.pool.wait();
                            object = this.pool.remove(0);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException("Thread interrupted while waiting for free object in pool", e);
                        }
                    }
                }
            } else {
                object = this.pool.remove(0);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(T object) throws PoolFullException {
        List<T> list = this.pool;
        synchronized (list) {
            this.validateObject(object);
            if (this.pool.size() == this.objectsCreated) {
                throw new PoolFullException("More objects have been returned than have been created by the pool");
            }
            this.pool.add(object);
            this.pool.notify();
            return;
        }
    }

    protected void validateObject(T object) throws InvalidObjectException {
    }

    public int getObjectsCreated() {
        return this.objectsCreated;
    }

    public int getObjectsInPool() {
        return this.pool.size();
    }
}

