/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.numbers;

import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class NumberUtils {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\D*");

    public static boolean isLong(Double value) {
        Long longValue;
        Double doubleValue;
        return value != null && (doubleValue = Double.valueOf((longValue = Long.valueOf(value.longValue())).doubleValue())).equals(value);
    }

    public static boolean isInt(String value) {
        if (value != null) {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isLong(String value) {
        if (value != null) {
            try {
                Long.parseLong(value);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isFloat(String value) {
        if (value != null) {
            try {
                Float.parseFloat(value);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isDouble(String value) {
        if (value != null) {
            try {
                Double.parseDouble(value);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isNumber(String value) {
        return NumberUtils.isDouble(value) || NumberUtils.isLong(value);
    }

    public static Integer toInt(String value) {
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Short toShort(String value) {
        if (value != null) {
            try {
                return Short.parseShort(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<Integer> toInt(Collection<? extends Object> list, Field field) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = field.getType();
        if (list != null && type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            ArrayList<Integer> validIntegers = new ArrayList<Integer>();
            for (Object object : list) {
                Integer value = (Integer)field.get(object);
                if (value == null) continue;
                validIntegers.add(value);
            }
            return validIntegers;
        }
        return null;
    }

    public static ArrayList<Integer> toInt(Collection<String> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Integer> validIntegers = new ArrayList<Integer>();
        for (String value : values) {
            Integer intValue;
            if (value == null || (intValue = NumberUtils.toInt(value)) == null) continue;
            validIntegers.add(intValue);
        }
        if (validIntegers.isEmpty()) {
            return null;
        }
        return validIntegers;
    }

    public static ArrayList<Integer> toInt(String[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<Integer> validIntegers = new ArrayList<Integer>();
        for (String value : values) {
            Integer intValue;
            if (value == null || (intValue = NumberUtils.toInt(value)) == null) continue;
            validIntegers.add(intValue);
        }
        if (validIntegers.isEmpty()) {
            return null;
        }
        return validIntegers;
    }

    public static Long toLong(String value) {
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Float toFloat(String value) {
        if (value != null) {
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<Float> toFloat(List<String> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Float> validFloats = new ArrayList<Float>();
        for (String value : values) {
            Float floatValue;
            if (value == null || (floatValue = NumberUtils.toFloat(value)) == null) continue;
            validFloats.add(floatValue);
        }
        if (validFloats.isEmpty()) {
            return null;
        }
        return validFloats;
    }

    public static Double toDouble(String value) {
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<Double> toDouble(List<String> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Double> validDoubles = new ArrayList<Double>();
        for (String value : values) {
            Double doubleValue;
            if (value == null || (doubleValue = NumberUtils.toDouble(value)) == null) continue;
            validDoubles.add(doubleValue);
        }
        if (validDoubles.isEmpty()) {
            return null;
        }
        return validDoubles;
    }

    public static List<Long> toLong(List<String> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Long> validLongs = new ArrayList<Long>();
        for (String value : values) {
            Long LongValue;
            if (value == null || (LongValue = NumberUtils.toLong(value)) == null) continue;
            validLongs.add(LongValue);
        }
        if (validLongs.isEmpty()) {
            return null;
        }
        return validLongs;
    }

    public static Long getNumbers(String revstring) {
        String result = NUMBER_PATTERN.matcher(revstring).replaceAll("");
        return NumberUtils.toLong(result);
    }

    public static String formatNumber(Number value, int minDecimals, int maxDecimals, boolean grouping, boolean dotDecimalSymbol) {
        DecimalFormat formatter = new DecimalFormat();
        formatter.setMinimumFractionDigits(minDecimals);
        formatter.setMaximumFractionDigits(maxDecimals);
        if (dotDecimalSymbol) {
            formatter.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        }
        formatter.setGroupingUsed(grouping);
        return formatter.format(value);
    }

    public static Byte toByte(String value) {
        if (value != null) {
            try {
                return Byte.parseByte(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isValidCC(String number) {
        int[][] sumTable = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, {0, 2, 4, 6, 8, 1, 3, 5, 7, 9}};
        int sum = 0;
        int flip = 0;
        for (int i = number.length() - 1; i >= 0; --i) {
            sum += sumTable[flip++ & 1][Character.digit(number.charAt(i), 10)];
        }
        return sum % 10 == 0;
    }

    public static int toPrimitiveInt(Integer integer) {
        if (integer == null) {
            return 0;
        }
        return integer;
    }

    public static int getLowestValue(int value1, int value2) {
        if (value1 < value2) {
            return value1;
        }
        return value2;
    }
}

