/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.mime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import se.unlogic.standardutils.io.FileUtils;

public class MimeUtils {
    private static String UNKNOWN_MIME_TYPE = "application/x-unknown";
    private static Properties MIME_TYPES = new Properties();

    public static String getMimeType(File file) {
        return MimeUtils.getMimeType(file.getName());
    }

    public static String getMimeType(String filename) {
        String fileExtension = FileUtils.getFileExtension(filename);
        if (fileExtension == null) {
            return UNKNOWN_MIME_TYPE;
        }
        return MIME_TYPES.getProperty(fileExtension.toLowerCase(), UNKNOWN_MIME_TYPE);
    }

    public static int getMimeTypeCount() {
        return MIME_TYPES.size();
    }

    public static Set<Map.Entry<Object, Object>> getMIME_TYPES() {
        return MIME_TYPES.entrySet();
    }

    public static void loadMimeTypes(InputStream inputStream) throws IOException {
        MIME_TYPES.clear();
        MIME_TYPES.load(inputStream);
    }

    public void loadMimeTypesFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        MIME_TYPES.loadFromXML(in);
    }

    static {
        try {
            MIME_TYPES.load(MimeUtils.class.getResourceAsStream("mimetypes.properties"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

