/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.json;

import se.unlogic.standardutils.json.JsonNode;
import se.unlogic.standardutils.numbers.NumberUtils;

public class JsonLeaf
implements JsonNode {
    private static final long serialVersionUID = 1198871458505471824L;
    private String value;
    private boolean appendQuotes = true;

    public JsonLeaf(String value) {
        this.value = value;
    }

    public JsonLeaf(String value, boolean appendQuotes) {
        this.value = value;
        this.appendQuotes = appendQuotes;
    }

    public boolean appendQuotes() {
        return this.appendQuotes;
    }

    @Override
    public String toJson() {
        return this.toJson(new StringBuilder());
    }

    @Override
    public String toJson(StringBuilder stringBuilder) {
        if (this.value == null) {
            return stringBuilder.append("null").toString();
        }
        if (NumberUtils.isNumber(this.value)) {
            stringBuilder.append(this.value);
        } else if (this.value.equals("false")) {
            stringBuilder.append(this.value);
        } else if (this.value.equals("true")) {
            stringBuilder.append(this.value);
        } else {
            if (this.appendQuotes) {
                stringBuilder.append("\"");
            }
            stringBuilder.append(this.getEscapedValue());
            if (this.appendQuotes) {
                stringBuilder.append("\"");
            }
        }
        return stringBuilder.toString();
    }

    private String getEscapedValue() {
        return this.value.replace("\t", "\\t").replace("\b", "\\b").replace("\n", "\\n").replace("\r", "\\r").replace("\f", "\\f").replace("\"", "\\\"");
    }
}

