/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import se.unlogic.standardutils.callback.Callback;
import se.unlogic.standardutils.io.ChannelUtils;
import se.unlogic.standardutils.streams.StreamUtils;

public class FileUtils {
    public static String toAsciiFilename(String string) {
        return string.replaceAll("[^0-9a-zA-Z-.]", "_");
    }

    public static String toValidHttpFilename(String string) {
        return string.replaceAll("[^0-9a-\u00f6A-\u00d6-+. ()-+!@\u00e9&%$\u00a7=]|[~]", "_");
    }

    public static final byte[] getRawBytes(File f) throws IOException {
        FileInputStream fin = new FileInputStream(f);
        byte[] buffer = new byte[(int)f.length()];
        fin.read(buffer);
        fin.close();
        return buffer;
    }

    public static String getFileExtension(File file) {
        return FileUtils.getFileExtension(file.getName());
    }

    public static String getFileExtension(String filename) {
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex == -1 || dotIndex + 1 == filename.length()) {
            return null;
        }
        return filename.substring(dotIndex + 1);
    }

    public static boolean fileExists(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    public static boolean isReadable(String path) {
        return FileUtils.isReadable(new File(path));
    }

    public static boolean isReadable(File file) {
        return file.exists() && file.canRead();
    }

    public static int deleteFiles(String directory, FileFilter filter, boolean recursive) {
        return FileUtils.deleteFiles(new File(directory), filter, recursive);
    }

    public static int deleteFiles(File dir, FileFilter filter, boolean recursive) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files;
            int deletedFiles = 0;
            for (File file : files = dir.listFiles(filter)) {
                if (file.isDirectory()) {
                    if (!recursive) continue;
                    deletedFiles += FileUtils.deleteFiles(file, filter, recursive);
                    continue;
                }
                if (filter != null && !filter.accept(file) || !file.delete()) continue;
                ++deletedFiles;
            }
            return deletedFiles;
        }
        return 0;
    }

    public static int replace(File dir, String filename, File replacementFile, boolean recursive, boolean caseSensitive, Callback<File> callback) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files;
            int replacedFiles = 0;
            for (File file : files = dir.listFiles()) {
                if (file.isDirectory()) {
                    if (!recursive) continue;
                    replacedFiles += FileUtils.replace(file, filename, replacementFile, recursive, caseSensitive, callback);
                    continue;
                }
                if ((!caseSensitive ? !file.getName().equalsIgnoreCase(filename) : !file.getName().equals(filename)) || !file.canWrite()) continue;
                try {
                    if (callback != null) {
                        callback.callback(file);
                    }
                    FileUtils.replaceFile(file, replacementFile);
                    ++replacedFiles;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return replacedFiles;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceFile(File target, File replacement) throws IOException {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(replacement);
            outputStream = new FileOutputStream(target);
            inputStream.getChannel().transferTo(0L, replacement.length(), outputStream.getChannel());
            StreamUtils.transfer(inputStream, outputStream);
        }
        catch (Throwable throwable) {
            StreamUtils.closeStream(inputStream);
            StreamUtils.closeStream(outputStream);
            throw throwable;
        }
        StreamUtils.closeStream(inputStream);
        StreamUtils.closeStream(outputStream);
    }

    public static boolean deleteDirectory(String directoryPath) {
        return FileUtils.deleteDirectory(new File(directoryPath));
    }

    public static boolean deleteDirectory(File directory) {
        if (directory.exists()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                if (file.isDirectory()) {
                    FileUtils.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return directory.delete();
    }

    public static boolean deleteFile(String path) {
        return FileUtils.deleteFile(new File(path));
    }

    public static boolean deleteFile(File file) {
        if (file != null && file.exists()) {
            return file.delete();
        }
        return false;
    }

    public static void writeFile(String filePath, byte[] data) throws IOException {
        FileUtils.writeFile(new File(filePath), (InputStream)new ByteArrayInputStream(data), true);
    }

    public static void writeFile(File file, byte[] data) throws IOException {
        FileUtils.writeFile(file, (InputStream)new ByteArrayInputStream(data), true);
    }

    public static void writeFile(String filePath, InputStream inputStream, boolean closeInputStream) throws IOException {
        FileUtils.writeFile(new File(filePath), inputStream, closeInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, InputStream inputStream, boolean closeInputStream) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            StreamUtils.transfer(inputStream, fileOutputStream);
        }
        finally {
            if (closeInputStream) {
                StreamUtils.closeStream(inputStream);
            }
            StreamUtils.closeStream(fileOutputStream);
        }
    }

    public static void downloadFile(String url, File destination) throws MalformedURLException, IOException {
        FileUtils.downloadFile(new URL(url), destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(URL url, File destination) throws IOException {
        ReadableByteChannel channel = null;
        FileOutputStream fileOutputStream = null;
        try {
            channel = Channels.newChannel(url.openStream());
            destination.getParentFile().mkdirs();
            fileOutputStream = new FileOutputStream(destination);
            fileOutputStream.getChannel().transferFrom(channel, 0L, 0x40000000L);
        }
        catch (Throwable throwable) {
            StreamUtils.closeStream(fileOutputStream);
            ChannelUtils.closeChannel(channel);
            throw throwable;
        }
        StreamUtils.closeStream(fileOutputStream);
        ChannelUtils.closeChannel(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String file, String content) throws IOException {
        FileOutputStream fileOutputStream = null;
        ByteArrayInputStream inputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            inputStream = new ByteArrayInputStream(content.getBytes());
            StreamUtils.transfer(inputStream, fileOutputStream);
        }
        catch (Throwable throwable) {
            StreamUtils.closeStream(inputStream);
            StreamUtils.closeStream(fileOutputStream);
            throw throwable;
        }
        StreamUtils.closeStream(inputStream);
        StreamUtils.closeStream(fileOutputStream);
    }

    public static String replaceFileExtension(String filename, String newExtension) {
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex == -1 || dotIndex + 1 == filename.length()) {
            return filename + "." + newExtension;
        }
        return filename.substring(0, dotIndex) + "." + newExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileInputStream inputStream = null;
        FileChannel source = null;
        FileOutputStream outputStream = null;
        FileChannel destination = null;
        try {
            inputStream = new FileInputStream(sourceFile);
            source = inputStream.getChannel();
            outputStream = new FileOutputStream(destFile);
            destination = outputStream.getChannel();
            long bytesTransfered = destination.transferFrom(source, 0L, source.size());
            if (bytesTransfered != sourceFile.length()) {
                throw new RuntimeException("Only " + bytesTransfered + " out of " + sourceFile.length() + " bytes transfered!");
            }
        }
        catch (Throwable throwable) {
            ChannelUtils.closeChannel(source);
            StreamUtils.closeStream(inputStream);
            ChannelUtils.closeChannel(destination);
            StreamUtils.closeStream(outputStream);
            throw throwable;
        }
        ChannelUtils.closeChannel(source);
        StreamUtils.closeStream(inputStream);
        ChannelUtils.closeChannel(destination);
        StreamUtils.closeStream(outputStream);
    }

    public static void moveFile(File sourceFile, File destFile) throws IOException {
        if (!sourceFile.renameTo(destFile)) {
            throw new IOException("Moving of file " + sourceFile + " to " + destFile + " failed");
        }
    }

    public static void createMissingDirectories(File file) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
    }
}

