/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.io;

import se.unlogic.standardutils.text.PooledDecimalFormat;

public class BinarySizeFormater {
    private static final PooledDecimalFormat DECIMAL_FORMAT = new PooledDecimalFormat("#.##");

    public static String getFormatedSize(long bytes) {
        if (bytes >= 0x40000000L) {
            return DECIMAL_FORMAT.format((double)bytes / 1.073741824E9) + " GB";
        }
        if (bytes >= 0x100000L) {
            return DECIMAL_FORMAT.format((double)bytes / 1048576.0) + " MB";
        }
        if (bytes >= 1024L) {
            return bytes / 1024L + " KB";
        }
        return bytes + " B";
    }
}

