/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.enums;

import java.lang.reflect.Field;
import java.util.ArrayList;

public class EnumUtils {
    public static <Type extends Enum<Type>> boolean isEnum(Class<Type> e, String s) {
        if (s == null) {
            return false;
        }
        try {
            Enum.valueOf(e, s);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static <Type extends Enum<Type>> Type toEnum(Class<Type> e, String s) {
        if (s == null) {
            return null;
        }
        try {
            return Enum.valueOf(e, s);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static <Type extends Enum<Type>> ArrayList<Type> toEnum(Class<Type> e, String[] values) {
        ArrayList<Type> enumValues = new ArrayList<Type>();
        for (String value : values) {
            Type enumValue = EnumUtils.toEnum(e, value);
            if (enumValue == null) continue;
            enumValues.add(enumValue);
        }
        if (enumValues.isEmpty()) {
            return null;
        }
        return enumValues;
    }

    public static <Type extends Enum<Type>> Type toEnum(Type[] es, int ordinal) {
        for (Type typeValue : es) {
            if (((Enum)typeValue).ordinal() != ordinal) continue;
            return typeValue;
        }
        return null;
    }

    public static Enum<?> getInstanceFromField(Field field) {
        ?[] enumValues = field.getType().getEnumConstants();
        return (Enum)enumValues[0];
    }

    public static Enum<?>[] getValuesFromField(Field field) {
        ?[] enumValues = field.getType().getEnumConstants();
        return (Enum[])enumValues;
    }
}

