/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.db.tableversionhandler;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.dao.querys.ObjectQuery;
import se.unlogic.standardutils.dao.querys.UpdateQuery;
import se.unlogic.standardutils.db.DBUtils;
import se.unlogic.standardutils.db.tableversionhandler.DBScript;
import se.unlogic.standardutils.db.tableversionhandler.DBScriptProvider;
import se.unlogic.standardutils.db.tableversionhandler.TableUpgradeException;
import se.unlogic.standardutils.db.tableversionhandler.UpgradeResult;
import se.unlogic.standardutils.populators.IntegerPopulator;
import se.unlogic.standardutils.string.StringUtils;

public class TableVersionHandler {
    public static UpgradeResult upgradeDBTables(DataSource dataSource, String tableGroupName, DBScriptProvider scriptProvider) throws TableUpgradeException, SQLException {
        return TableVersionHandler.upgradeDBTables(dataSource, tableGroupName, scriptProvider, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpgradeResult upgradeDBTables(DataSource dataSource, String tableGroupName, DBScriptProvider scriptProvider, Integer initialVersion, Integer maxVersion) throws TableUpgradeException, SQLException {
        UpgradeResult upgradeResult;
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(dataSource);
            if (initialVersion == null && (initialVersion = TableVersionHandler.getTableGroupVersion(transactionHandler, tableGroupName)) == null) {
                initialVersion = 0;
            }
            int currentVersion = initialVersion;
            try {
                while (maxVersion == null || currentVersion < maxVersion) {
                    DBScript script;
                    if ((script = scriptProvider.getScript(++currentVersion)) == null) {
                        --currentVersion;
                        break;
                    }
                    script.execute(transactionHandler);
                }
                if (currentVersion != initialVersion) {
                    TableVersionHandler.setTableGroupVersion(transactionHandler, tableGroupName, currentVersion);
                }
                transactionHandler.commit();
            }
            catch (Exception e) {
                throw new TableUpgradeException("Error upgrading table group " + tableGroupName + ". Initial version " + initialVersion + ", upgrade failed at version " + currentVersion, e);
            }
            upgradeResult = new UpgradeResult(tableGroupName, initialVersion, currentVersion);
        }
        catch (Throwable throwable) {
            TransactionHandler.autoClose(transactionHandler);
            throw throwable;
        }
        TransactionHandler.autoClose(transactionHandler);
        return upgradeResult;
    }

    public static void setTableGroupVersion(TransactionHandler transactionHandler, String tableGroupName, int version) throws SQLException {
        TableVersionHandler.checkTableGroupName(tableGroupName);
        if (!DBUtils.tableExists(transactionHandler.getMetaData(), "table_versions")) {
            try {
                String sql = StringUtils.readStreamAsString(TableVersionHandler.class.getResourceAsStream("TableVersionHandler.sql"));
                UpdateQuery createTableQuery = transactionHandler.getUpdateQuery(sql);
                createTableQuery.executeUpdate();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        UpdateQuery deleteQuery = transactionHandler.getUpdateQuery("DELETE FROM table_versions WHERE tableGroupName = ?");
        deleteQuery.setString(1, tableGroupName);
        deleteQuery.executeUpdate();
        UpdateQuery insertQuery = transactionHandler.getUpdateQuery("INSERT INTO table_versions VALUES (?,?)");
        insertQuery.setString(1, tableGroupName);
        insertQuery.setInt(2, version);
        insertQuery.executeUpdate();
    }

    public static Integer getTableGroupVersion(TransactionHandler transactionHandler, String tableGroupName) throws SQLException {
        if (!DBUtils.tableExists(transactionHandler.getMetaData(), "table_versions")) {
            return null;
        }
        ObjectQuery<Integer> query = transactionHandler.getObjectQuery("SELECT version FROM table_versions WHERE tableGroupName = ?", IntegerPopulator.getPopulator());
        query.setString(1, tableGroupName);
        return query.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getTableGroupVersion(DataSource dataSource, String tableGroupName) throws SQLException {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            Integer n = TableVersionHandler.getTableGroupVersion(connection, tableGroupName);
            return n;
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }

    public static Integer getTableGroupVersion(Connection connection, String tableGroupName) throws SQLException {
        if (!DBUtils.tableExists(connection.getMetaData(), "table_versions")) {
            return null;
        }
        ObjectQuery<Integer> query = new ObjectQuery<Integer>(connection, false, "SELECT version FROM table_versions WHERE tableGroupName = ?", (BeanResultSetPopulator<Integer>)IntegerPopulator.getPopulator());
        query.setString(1, tableGroupName);
        return query.executeQuery();
    }

    private static void checkTableGroupName(String tableGroupName) {
        if (tableGroupName.length() > 255) {
            throw new RuntimeException("Table group name cannot be longer than 255 characters");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTableGroupVersion(DataSource dataSource, String tableGroupName, int version) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(dataSource);
            TableVersionHandler.setTableGroupVersion(transactionHandler, tableGroupName, version);
            transactionHandler.commit();
        }
        catch (Throwable throwable) {
            TransactionHandler.autoClose(transactionHandler);
            throw throwable;
        }
        TransactionHandler.autoClose(transactionHandler);
    }
}

