/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.date;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import se.unlogic.standardutils.factory.BeanFactory;

public class SimpleDateFormatFactory
implements BeanFactory<SimpleDateFormat> {
    protected String format;
    protected Locale locale;
    protected TimeZone timeZone;

    public SimpleDateFormatFactory(String format) {
        this.format = format;
    }

    public SimpleDateFormatFactory(String format, Locale locale) {
        this(format);
        this.locale = locale;
    }

    public SimpleDateFormatFactory(String format, Locale locale, TimeZone timeZone) {
        this(format, locale);
        this.timeZone = timeZone;
    }

    @Override
    public SimpleDateFormat newInstance() {
        SimpleDateFormat simpleDateFormat = this.locale != null ? new SimpleDateFormat(this.format, this.locale) : new SimpleDateFormat(this.format);
        if (this.timeZone != null) {
            simpleDateFormat.setTimeZone(this.timeZone);
        }
        return simpleDateFormat;
    }
}

