/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import se.unlogic.standardutils.date.SimpleDateFormatFactory;
import se.unlogic.standardutils.date.ThreadSafeDateFormat;
import se.unlogic.standardutils.pool.GenericObjectPool;

public class PooledSimpleDateFormat
implements ThreadSafeDateFormat {
    protected GenericObjectPool<SimpleDateFormat> pool;

    public PooledSimpleDateFormat(String format) {
        this.pool = new GenericObjectPool<SimpleDateFormat>(new SimpleDateFormatFactory(format));
    }

    public PooledSimpleDateFormat(String format, Locale locale) {
        this.pool = new GenericObjectPool<SimpleDateFormat>(new SimpleDateFormatFactory(format, locale));
    }

    public PooledSimpleDateFormat(String format, Locale locale, TimeZone timeZone) {
        this.pool = new GenericObjectPool<SimpleDateFormat>(new SimpleDateFormatFactory(format, locale, timeZone));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date parse(String date) throws ParseException {
        SimpleDateFormat dateFormat = null;
        try {
            dateFormat = this.pool.borrowObject();
            Date date2 = dateFormat.parse(date);
            return date2;
        }
        finally {
            this.pool.returnObject(dateFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(Date date) {
        SimpleDateFormat dateFormat = null;
        try {
            dateFormat = this.pool.borrowObject();
            String string = dateFormat.format(date);
            return string;
        }
        finally {
            this.pool.returnObject(dateFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Object date) {
        SimpleDateFormat dateFormat = null;
        try {
            dateFormat = this.pool.borrowObject();
            String string = dateFormat.format(date);
            return string;
        }
        finally {
            this.pool.returnObject(dateFormat);
        }
    }

    public int getObjectsCreated() {
        return this.pool.getObjectsCreated();
    }

    public int getObjectsInPool() {
        return this.pool.getObjectsInPool();
    }
}

