/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.date;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import se.unlogic.standardutils.date.PooledSimpleDateFormat;
import se.unlogic.standardutils.date.ThreadSafeDateFormat;

public class DateUtils {
    public static final PooledSimpleDateFormat DATE_TIME_SECONDS_FORMATTER = new PooledSimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final PooledSimpleDateFormat DATE_TIME_FORMATTER = new PooledSimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final PooledSimpleDateFormat DATE_FORMATTER = new PooledSimpleDateFormat("yyyy-MM-dd");
    public static final PooledSimpleDateFormat YEAR_FORMATTER = new PooledSimpleDateFormat("yyyy");
    public static final PooledSimpleDateFormat YEAR_WEEK_FORMATTER = new PooledSimpleDateFormat("w");

    public static boolean isValidDate(ThreadSafeDateFormat sdf, String date) {
        try {
            sdf.parse(date);
        }
        catch (ParseException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public static boolean isValidDate(DateFormat sdf, String date) {
        try {
            sdf.parse(date);
        }
        catch (ParseException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public static Date getDate(ThreadSafeDateFormat sdf, String date) {
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static Date getDate(DateFormat sdf, String date) {
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static long daysBetween(Date startDate, Date endDate) {
        Calendar start = Calendar.getInstance();
        start.setTime(startDate);
        Calendar end = Calendar.getInstance();
        end.setTime(endDate);
        return DateUtils.daysBetween(start, end);
    }

    public static long daysBetween(Calendar startDate, Calendar endDate) {
        startDate = (Calendar)startDate.clone();
        long daysBetween = 0L;
        while (startDate.get(1) < endDate.get(1)) {
            if (startDate.get(6) != 1) {
                int diff = startDate.getMaximum(6) - startDate.get(6);
                startDate.add(6, ++diff);
                daysBetween += (long)diff;
                continue;
            }
            daysBetween += (long)startDate.getMaximum(6);
            startDate.add(1, 1);
        }
        return daysBetween += (long)(endDate.get(6) - startDate.get(6));
    }

    public static int getCurrentYear() {
        return Integer.parseInt(YEAR_FORMATTER.format(new Date()));
    }

    public static int getCurrentWeek() {
        return Integer.parseInt(YEAR_WEEK_FORMATTER.format(new Date()));
    }

    public static java.sql.Date getCurrentSQLDate(boolean includeTime) {
        java.sql.Date date = new java.sql.Date(System.currentTimeMillis());
        if (includeTime) {
            return date;
        }
        return DateUtils.setTimeToMidnight(date);
    }

    public static <T extends Date> T setTimeToMidnight(T date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date.setTime(calendar.getTimeInMillis());
        return date;
    }

    public static <T extends Date> T setTimeToMaximum(T date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        date.setTime(calendar.getTimeInMillis());
        return date;
    }

    public static final String dateAndShortMonthToString(Date date, Locale locale) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String[] monthNames = new DateFormatSymbols(locale).getShortMonths();
        return calendar.get(5) + " " + monthNames[calendar.get(2)];
    }

    public static int getWorkingDays(Date startDate, Date endDate) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate);
        int workDays = 0;
        if (startCal.getTimeInMillis() > endCal.getTimeInMillis()) {
            startCal.setTime(endDate);
            endCal.setTime(startDate);
        }
        do {
            startCal.add(5, 1);
            if (startCal.get(7) == 7 || startCal.get(7) == 1) continue;
            ++workDays;
        } while (startCal.getTimeInMillis() <= endCal.getTimeInMillis());
        return workDays;
    }

    public static int getNumberOfWeeksInYear(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, 11);
        cal.set(5, 31);
        int week = cal.get(3);
        if (week == 1) {
            return 52;
        }
        return week;
    }

    public static java.sql.Date getTodaysDatePlusMinusDays(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, days);
        return new java.sql.Date(calendar.getTimeInMillis());
    }
}

