/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.datatypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.standardutils.xml.Elementable;

public class Matrix<CellType>
implements Elementable {
    private CellType[][] matrix;

    public Matrix(int rows, int cols) {
        this.matrix = new Object[rows][cols];
    }

    public List<CellType> getRow(int rowPos) {
        return Arrays.asList(this.matrix[rowPos]);
    }

    public List<CellType> getColumn(int columnPos) {
        ArrayList<CellType> columnCells = new ArrayList<CellType>(this.getColumnCount());
        for (CellType[] row : this.matrix) {
            columnCells.add(row[columnPos]);
        }
        return columnCells;
    }

    public CellType getCell(int rowPos, int colPos) {
        return this.matrix[rowPos][colPos];
    }

    public void setCell(int rowPos, int colPos, CellType cell) {
        this.matrix[rowPos][colPos] = cell;
    }

    public int getRowCount() {
        return this.matrix.length;
    }

    public int getColumnCount() {
        return this.matrix[0].length;
    }

    @Override
    public Element toXML(Document doc) {
        Element matrixElement = doc.createElement("Matrix");
        for (CellType[] row : this.matrix) {
            Element rowElement = doc.createElement("Row");
            matrixElement.appendChild(rowElement);
            for (CellType cell : row) {
                Element cellElement = doc.createElement("Cell");
                rowElement.appendChild(cellElement);
                if (cell == null) continue;
                cellElement.appendChild(doc.createTextNode(cell.toString()));
            }
        }
        return matrixElement;
    }
}

