/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao.querys;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.sql.DataSource;
import se.unlogic.standardutils.db.DBUtils;

public abstract class PreparedStatementQuery {
    protected Connection connection;
    protected boolean closeConnectionOnExit;
    protected PreparedStatement pstmt;
    protected boolean closed;

    public PreparedStatementQuery(Connection connection, boolean closeConnectionOnExit, String query) throws SQLException {
        this.closeConnectionOnExit = closeConnectionOnExit;
        this.connection = connection;
        try {
            this.pstmt = this.getPreparedStatement(query);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    protected PreparedStatement getPreparedStatement(String query) throws SQLException {
        return this.connection.prepareStatement(query, 1);
    }

    public PreparedStatementQuery(DataSource dataSource, String query) throws SQLException {
        this(dataSource.getConnection(), true, query);
    }

    public void setArray(int arg0, Array arg1) throws SQLException {
        try {
            this.pstmt.setArray(arg0, arg1);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        try {
            this.pstmt.setAsciiStream(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        try {
            this.pstmt.setBigDecimal(arg0, arg1);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        try {
            this.pstmt.setBinaryStream(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setBlob(int arg0, Blob arg1) throws SQLException {
        try {
            this.pstmt.setBlob(arg0, arg1);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setBoolean(int arg0, boolean arg1) throws SQLException {
        try {
            this.pstmt.setBoolean(arg0, arg1);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setByte(int arg0, byte arg1) throws SQLException {
        try {
            this.pstmt.setByte(arg0, arg1);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setBytes(int arg0, byte[] arg1) throws SQLException {
        try {
            this.pstmt.setBytes(arg0, arg1);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
        try {
            this.pstmt.setCharacterStream(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setClob(int arg0, Clob arg1) throws SQLException {
        try {
            this.pstmt.setClob(arg0, arg1);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setCursorName(String arg0) throws SQLException {
        try {
            this.pstmt.setCursorName(arg0);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setDate(int arg0, Date arg1, Calendar arg2) throws SQLException {
        try {
            this.pstmt.setDate(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setDate(int arg0, Date arg1) throws SQLException {
        try {
            this.pstmt.setDate(arg0, arg1);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setDouble(int arg0, double arg1) throws SQLException {
        try {
            this.pstmt.setDouble(arg0, arg1);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setEscapeProcessing(boolean arg0) throws SQLException {
        try {
            this.pstmt.setEscapeProcessing(arg0);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setFetchDirection(int arg0) throws SQLException {
        try {
            this.pstmt.setFetchDirection(arg0);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setFetchSize(int arg0) throws SQLException {
        try {
            this.pstmt.setFetchSize(arg0);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setFloat(int arg0, float arg1) throws SQLException {
        try {
            this.pstmt.setFloat(arg0, arg1);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setInt(int arg0, int arg1) throws SQLException {
        try {
            this.pstmt.setInt(arg0, arg1);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setLong(int arg0, long arg1) throws SQLException {
        try {
            this.pstmt.setLong(arg0, arg1);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setMaxFieldSize(int arg0) throws SQLException {
        try {
            this.pstmt.setMaxFieldSize(arg0);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setMaxRows(int arg0) throws SQLException {
        try {
            this.pstmt.setMaxRows(arg0);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setNull(int arg0, int arg1, String arg2) throws SQLException {
        try {
            this.pstmt.setNull(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setNull(int arg0, int arg1) throws SQLException {
        try {
            this.pstmt.setNull(arg0, arg1);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setObject(int arg0, Object arg1, int arg2, int arg3) throws SQLException {
        try {
            this.pstmt.setObject(arg0, arg1, arg2, arg3);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setObject(int arg0, Object arg1, int arg2) throws SQLException {
        try {
            this.pstmt.setObject(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setObject(int arg0, Object arg1) throws SQLException {
        try {
            this.pstmt.setObject(arg0, arg1);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setQueryTimeout(int arg0) throws SQLException {
        try {
            this.pstmt.setQueryTimeout(arg0);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setRef(int arg0, Ref arg1) throws SQLException {
        try {
            this.pstmt.setRef(arg0, arg1);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setShort(int arg0, short arg1) throws SQLException {
        try {
            this.pstmt.setShort(arg0, arg1);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setString(int arg0, String arg1) throws SQLException {
        try {
            this.pstmt.setString(arg0, arg1);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setTime(int arg0, Time arg1, Calendar arg2) throws SQLException {
        try {
            this.pstmt.setTime(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setTime(int arg0, Time arg1) throws SQLException {
        try {
            this.pstmt.setTime(arg0, arg1);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setTimestamp(int arg0, Timestamp arg1, Calendar arg2) throws SQLException {
        try {
            this.pstmt.setTimestamp(arg0, arg1, arg2);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setTimestamp(int arg0, Timestamp arg1) throws SQLException {
        try {
            this.pstmt.setTimestamp(arg0, arg1);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public void setURL(int arg0, URL arg1) throws SQLException {
        try {
            this.pstmt.setURL(arg0, arg1);
        }
        catch (SQLException e) {
            this.abort();
            throw e;
        }
    }

    public boolean isCloseConnectionOnExit() {
        return this.closeConnectionOnExit;
    }

    public void abort() {
        DBUtils.closePreparedStatement(this.pstmt);
        if (this.closeConnectionOnExit) {
            DBUtils.closeConnection(this.connection);
        }
        this.closed = true;
    }

    public static void autoCloseQuery(PreparedStatementQuery query) {
        if (query != null && !query.isClosed()) {
            query.abort();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

