/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.AnnotatedDAOFactory;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.populators.QueryParameterPopulator;
import se.unlogic.standardutils.populators.annotated.AnnotatedResultSetPopulator;

public class SimpleAnnotatedDAOFactory
implements AnnotatedDAOFactory {
    protected final DataSource dataSource;
    protected final HashMap<Class<?>, AnnotatedDAO<?>> daoMap = new HashMap();
    protected List<QueryParameterPopulator<?>> queryParameterPopulators;
    protected List<BeanStringPopulator<?>> beanStringPopulators;

    public SimpleAnnotatedDAOFactory(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public SimpleAnnotatedDAOFactory() {
        this.dataSource = null;
    }

    public SimpleAnnotatedDAOFactory(DataSource dataSource, List<QueryParameterPopulator<?>> queryParameterPopulators, List<BeanStringPopulator<?>> beanStringPopulators) {
        this.dataSource = dataSource;
        this.queryParameterPopulators = queryParameterPopulators;
        this.beanStringPopulators = beanStringPopulators;
    }

    @Override
    public synchronized <T> AnnotatedDAO<T> getDAO(Class<T> beanClass) {
        AnnotatedDAO<Object> dao = this.daoMap.get(beanClass);
        if (dao == null) {
            dao = new AnnotatedDAO<T>(this.dataSource, beanClass, (AnnotatedDAOFactory)this, this.queryParameterPopulators, this.beanStringPopulators);
            this.daoMap.put(beanClass, dao);
        }
        return dao;
    }

    public synchronized <T> AnnotatedDAO<T> getDAO(Class<T> beanClass, AnnotatedResultSetPopulator<T> populator) {
        AnnotatedDAO<Object> dao = this.daoMap.get(beanClass);
        if (dao == null) {
            dao = new AnnotatedDAO<T>(this.dataSource, beanClass, (AnnotatedDAOFactory)this, populator, (List<QueryParameterPopulator<?>>)null, (List<BeanStringPopulator<?>>)null);
            this.daoMap.put(beanClass, dao);
        }
        return dao;
    }

    public synchronized <T> AnnotatedDAO<T> getDAO(Class<T> beanClass, AnnotatedResultSetPopulator<T> populator, QueryParameterPopulator<?> ... queryParameterPopulators) {
        AnnotatedDAO<Object> dao = this.daoMap.get(beanClass);
        if (dao == null) {
            dao = new AnnotatedDAO<T>(this.dataSource, beanClass, (AnnotatedDAOFactory)this, populator, queryParameterPopulators);
            this.daoMap.put(beanClass, dao);
        }
        return dao;
    }

    public synchronized <T> AnnotatedDAO<T> getDAO(Class<T> beanClass, List<? extends QueryParameterPopulator<?>> queryParameterPopulators, List<? extends BeanStringPopulator<?>> typePopulators) {
        AnnotatedDAO<Object> dao = this.daoMap.get(beanClass);
        if (dao == null) {
            dao = new AnnotatedDAO<T>(this.dataSource, beanClass, (AnnotatedDAOFactory)this, queryParameterPopulators, typePopulators);
            this.daoMap.put(beanClass, dao);
        }
        return dao;
    }

    public synchronized <T> AnnotatedDAO<T> getDAO(Class<T> beanClass, AnnotatedResultSetPopulator<T> populator, List<? extends QueryParameterPopulator<?>> queryParameterPopulators, List<? extends BeanStringPopulator<?>> typePopulators) {
        AnnotatedDAO<Object> dao = this.daoMap.get(beanClass);
        if (dao == null) {
            dao = new AnnotatedDAO<T>(this.dataSource, beanClass, (AnnotatedDAOFactory)this, populator, queryParameterPopulators, typePopulators);
            this.daoMap.put(beanClass, dao);
        }
        return dao;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void addDAO(Class<?> beanClass, AnnotatedDAO<?> daoInstance) {
        this.daoMap.put(beanClass, daoInstance);
    }

    public void addQueryParameterPopulator(QueryParameterPopulator<?> o) {
        this.queryParameterPopulators = CollectionUtils.instantiateIfNeeded(this.queryParameterPopulators);
        this.queryParameterPopulators.add(o);
    }

    public void addQueryParameterPopulators(Collection<? extends QueryParameterPopulator<?>> c) {
        this.queryParameterPopulators = CollectionUtils.instantiateIfNeeded(this.queryParameterPopulators);
        this.queryParameterPopulators.addAll(c);
    }

    public boolean addBeanStringPopulator(BeanStringPopulator<?> o) {
        this.beanStringPopulators = CollectionUtils.instantiateIfNeeded(this.beanStringPopulators);
        return this.beanStringPopulators.add(o);
    }

    public boolean addBeanStringPopulators(Collection<? extends BeanStringPopulator<?>> c) {
        this.beanStringPopulators = CollectionUtils.instantiateIfNeeded(this.beanStringPopulators);
        return this.beanStringPopulators.addAll(c);
    }

    public List<? extends QueryParameterPopulator<?>> getQueryParameterPopulators() {
        return this.queryParameterPopulators;
    }

    public List<? extends BeanStringPopulator<?>> getBeanStringPopulators() {
        return this.beanStringPopulators;
    }
}

