/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao;

import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedHashMap;

public class ResultSetMethods {
    private static final LinkedHashMap<Class<?>, Method> RESULTSET_COLUMNNAME_METHODS = new LinkedHashMap();
    private static final LinkedHashMap<Class<?>, Method> RESULTSET_COLUMNINDEX_METHODS;

    public static Method getColumnNameMethod(Class<?> clazz) {
        return RESULTSET_COLUMNNAME_METHODS.get(clazz);
    }

    public static Method getColumnIndexMethod(Class<?> clazz) {
        return RESULTSET_COLUMNINDEX_METHODS.get(clazz);
    }

    static {
        try {
            RESULTSET_COLUMNNAME_METHODS.put(String.class, ResultSet.class.getMethod("getString", String.class));
            RESULTSET_COLUMNNAME_METHODS.put(Timestamp.class, ResultSet.class.getMethod("getTimestamp", String.class));
            RESULTSET_COLUMNNAME_METHODS.put(Blob.class, ResultSet.class.getMethod("getBlob", String.class));
            RESULTSET_COLUMNNAME_METHODS.put(Date.class, ResultSet.class.getMethod("getDate", String.class));
            RESULTSET_COLUMNNAME_METHODS.put(Time.class, ResultSet.class.getMethod("getTime", String.class));
            RESULTSET_COLUMNNAME_METHODS.put(Boolean.class, ResultSet.class.getMethod("getBoolean", String.class));
            RESULTSET_COLUMNNAME_METHODS.put(Boolean.TYPE, ResultSet.class.getMethod("getBoolean", String.class));
            RESULTSET_COLUMNNAME_METHODS.put(Integer.class, ResultSet.class.getMethod("getInt", String.class));
            RESULTSET_COLUMNNAME_METHODS.put(Integer.TYPE, ResultSet.class.getMethod("getInt", String.class));
            RESULTSET_COLUMNNAME_METHODS.put(Long.class, ResultSet.class.getMethod("getLong", String.class));
            RESULTSET_COLUMNNAME_METHODS.put(Long.TYPE, ResultSet.class.getMethod("getLong", String.class));
            RESULTSET_COLUMNNAME_METHODS.put(Float.class, ResultSet.class.getMethod("getFloat", String.class));
            RESULTSET_COLUMNNAME_METHODS.put(Float.TYPE, ResultSet.class.getMethod("getFloat", String.class));
            RESULTSET_COLUMNNAME_METHODS.put(Double.class, ResultSet.class.getMethod("getDouble", String.class));
            RESULTSET_COLUMNNAME_METHODS.put(Double.TYPE, ResultSet.class.getMethod("getDouble", String.class));
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        RESULTSET_COLUMNINDEX_METHODS = new LinkedHashMap();
        try {
            RESULTSET_COLUMNINDEX_METHODS.put(Integer.TYPE, ResultSet.class.getMethod("getString", Integer.TYPE));
            RESULTSET_COLUMNINDEX_METHODS.put(Timestamp.class, ResultSet.class.getMethod("getTimestamp", Integer.TYPE));
            RESULTSET_COLUMNINDEX_METHODS.put(Blob.class, ResultSet.class.getMethod("getBlob", Integer.TYPE));
            RESULTSET_COLUMNINDEX_METHODS.put(Date.class, ResultSet.class.getMethod("getDate", Integer.TYPE));
            RESULTSET_COLUMNINDEX_METHODS.put(Time.class, ResultSet.class.getMethod("getTime", Integer.TYPE));
            RESULTSET_COLUMNINDEX_METHODS.put(Boolean.class, ResultSet.class.getMethod("getBoolean", Integer.TYPE));
            RESULTSET_COLUMNINDEX_METHODS.put(Boolean.TYPE, ResultSet.class.getMethod("getBoolean", Integer.TYPE));
            RESULTSET_COLUMNINDEX_METHODS.put(Integer.class, ResultSet.class.getMethod("getInt", Integer.TYPE));
            RESULTSET_COLUMNINDEX_METHODS.put(Integer.TYPE, ResultSet.class.getMethod("getInt", Integer.TYPE));
            RESULTSET_COLUMNINDEX_METHODS.put(Long.class, ResultSet.class.getMethod("getLong", Integer.TYPE));
            RESULTSET_COLUMNINDEX_METHODS.put(Long.TYPE, ResultSet.class.getMethod("getLong", Integer.TYPE));
            RESULTSET_COLUMNINDEX_METHODS.put(Float.class, ResultSet.class.getMethod("getFloat", Integer.TYPE));
            RESULTSET_COLUMNINDEX_METHODS.put(Float.TYPE, ResultSet.class.getMethod("getFloat", Integer.TYPE));
            RESULTSET_COLUMNINDEX_METHODS.put(Double.class, ResultSet.class.getMethod("getDouble", Integer.TYPE));
            RESULTSET_COLUMNINDEX_METHODS.put(Double.TYPE, ResultSet.class.getMethod("getDouble", Integer.TYPE));
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

