/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.dao.OrderByCriteria;
import se.unlogic.standardutils.dao.QueryParameter;
import se.unlogic.standardutils.dao.RelationOrderByHandler;
import se.unlogic.standardutils.dao.RelationParameterHandler;
import se.unlogic.standardutils.dao.RelationRowLimiterHandler;
import se.unlogic.standardutils.dao.RowLimiter;

public class RelationQuery
implements Cloneable {
    private List<Field> relations;
    private List<Field> excludedRelations;
    private List<Field> excludedFields;
    private boolean disableAutoRelations;
    private RelationParameterHandler relationParameterHandler;
    private RelationOrderByHandler relationOrderByHandler;
    private RelationRowLimiterHandler relationRowLimiterHandler;

    public RelationQuery() {
    }

    public RelationQuery(List<Field> relations) {
        this.relations = relations;
    }

    public RelationQuery(Field ... relations) {
        this.addRelations(relations);
    }

    public RelationQuery(RelationQuery relationQuery) {
        if (relationQuery == null) {
            return;
        }
        this.addRelations(relationQuery);
        this.addExcludedRelations(relationQuery);
        this.addExcludedFields(relationQuery);
        this.disableAutoRelations(relationQuery.isDisableAutoRelations());
        this.relationParameterHandler = relationQuery.getRelationParameterHandler();
        this.relationOrderByHandler = relationQuery.getRelationOrderByHandler();
        this.relationRowLimiterHandler = relationQuery.getRelationRowLimiterHandler();
    }

    public List<Field> getRelations() {
        return this.relations;
    }

    public void setRelations(List<Field> relations) {
        this.relations = relations;
    }

    public void addRelation(Field relation) {
        if (this.relations == null) {
            this.relations = new ArrayList<Field>();
        }
        this.relations.add(relation);
    }

    public void addRelations(Field ... relations) {
        if (this.relations == null) {
            this.relations = new ArrayList<Field>();
        }
        this.relations.addAll(Arrays.asList(relations));
    }

    public static boolean hasRelations(RelationQuery query) {
        return query != null && query.getRelations() != null && !query.getRelations().isEmpty();
    }

    public boolean hasRelations() {
        return RelationQuery.hasRelations(this);
    }

    public void addRelations(RelationQuery relationQuery) {
        if (RelationQuery.hasRelations(relationQuery)) {
            this.addRelations(relationQuery.getRelations());
        }
    }

    public void addRelations(List<Field> relations) {
        if (this.relations == null) {
            this.relations = relations;
        } else {
            this.relations.addAll(relations);
        }
    }

    public List<Field> getExcludedRelations() {
        return this.excludedRelations;
    }

    public void setExcludedRelations(List<Field> excludedRelations) {
        this.excludedRelations = excludedRelations;
    }

    public void addExcludedRelation(Field relation) {
        if (this.excludedRelations == null) {
            this.excludedRelations = new ArrayList<Field>();
        }
        this.excludedRelations.add(relation);
    }

    public void addExcludedRelations(Field ... excludedRelations) {
        if (this.excludedRelations == null) {
            this.excludedRelations = new ArrayList<Field>();
        }
        this.excludedRelations.addAll(Arrays.asList(excludedRelations));
    }

    public static boolean hasExcludedRelations(RelationQuery query) {
        return query != null && query.getExcludedRelations() != null && !query.getExcludedRelations().isEmpty();
    }

    public boolean hasExcludedRelations() {
        return RelationQuery.hasExcludedRelations(this);
    }

    public void addExcludedRelations(RelationQuery relationQuery) {
        if (RelationQuery.hasExcludedRelations(relationQuery)) {
            this.addExcludedRelations(relationQuery.getExcludedRelations());
        }
    }

    public void addExcludedRelations(List<Field> excludedRelations) {
        if (this.excludedRelations == null) {
            this.excludedRelations = excludedRelations;
        } else {
            this.excludedRelations.addAll(excludedRelations);
        }
    }

    public boolean containsRelation(Field field) {
        if (this.relations != null) {
            return this.relations.contains(field);
        }
        return false;
    }

    public boolean containsExcludedRelation(Field field) {
        if (this.excludedRelations != null) {
            return this.excludedRelations.contains(field);
        }
        return false;
    }

    public boolean isDisableAutoRelations() {
        return this.disableAutoRelations;
    }

    public void disableAutoRelations(boolean disableAutoRelations) {
        this.disableAutoRelations = disableAutoRelations;
    }

    public RelationQuery clone() throws CloneNotSupportedException {
        RelationQuery clone = (RelationQuery)super.clone();
        if (this.excludedFields != null) {
            clone.excludedFields = new ArrayList<Field>(this.excludedFields);
        }
        if (this.excludedRelations != null) {
            clone.excludedRelations = new ArrayList<Field>(this.excludedRelations);
        }
        if (this.relations != null) {
            clone.relations = new ArrayList<Field>(this.relations);
        }
        return clone;
    }

    public List<Field> getExcludedFields() {
        return this.excludedFields;
    }

    public void setExcludedFields(List<Field> excludedFields) {
        this.excludedFields = excludedFields;
    }

    public void addExcludedField(Field field) {
        this.excludedFields = CollectionUtils.addAndInstantiateIfNeeded(this.excludedFields, field);
    }

    public void addExcludedFields(Field ... fields) {
        this.excludedFields = CollectionUtils.addAndInstantiateIfNeeded(this.excludedFields, Arrays.asList(fields));
    }

    public void addExcludedFields(List<Field> fields) {
        this.excludedFields = CollectionUtils.addAndInstantiateIfNeeded(this.excludedFields, fields);
    }

    public boolean hasExcludedFields() {
        return RelationQuery.hasExcludedFields(this);
    }

    public static boolean hasExcludedFields(RelationQuery query) {
        return query != null && query.getExcludedFields() != null && !query.getExcludedFields().isEmpty();
    }

    public boolean containsExcludedField(Field field) {
        if (this.excludedFields != null) {
            return this.excludedFields.contains(field);
        }
        return false;
    }

    public void addExcludedFields(RelationQuery relationQuery) {
        if (RelationQuery.hasExcludedFields(relationQuery)) {
            this.addExcludedFields(relationQuery.getExcludedFields());
        }
    }

    public RelationParameterHandler getRelationParameterHandler() {
        return this.relationParameterHandler;
    }

    public void setRelationParameterHandler(RelationParameterHandler relationParameterHandler) {
        this.relationParameterHandler = relationParameterHandler;
    }

    public <X> void addRelationParameter(Class<X> clazz, QueryParameter<X, ?> queryParameter) {
        this.checkRelationParameterHandler();
        this.relationParameterHandler.addRelationParameter(clazz, queryParameter);
    }

    public <X> List<QueryParameter<X, ?>> getRelationParameters(Class<X> clazz) {
        if (this.relationParameterHandler == null) {
            return null;
        }
        return this.relationParameterHandler.getRelationParameters(clazz);
    }

    public <X> void addRelationOrderByCriteria(Class<X> clazz, OrderByCriteria<X> orderByCriteria) {
        this.checkRelationOrderByHandler();
        this.relationOrderByHandler.addRelationOrderByCriteria(clazz, orderByCriteria);
    }

    public <X> List<OrderByCriteria<X>> getRelationOrderByCriterias(Class<X> clazz) {
        if (this.relationOrderByHandler == null) {
            return null;
        }
        return this.relationOrderByHandler.getRelationOrderByCriterias(clazz);
    }

    public void addRelationRowLimiter(Class<?> clazz, RowLimiter rowLimiter) {
        this.checkRelationRowLimiterHandler();
        this.relationRowLimiterHandler.addRelationParameter(clazz, rowLimiter);
    }

    public RowLimiter getRelationRowLimiter(Class<?> clazz) {
        if (this.relationRowLimiterHandler == null) {
            return null;
        }
        return this.relationRowLimiterHandler.getRowLimitier(clazz);
    }

    private void checkRelationParameterHandler() {
        if (this.relationParameterHandler == null) {
            this.relationParameterHandler = new RelationParameterHandler();
        }
    }

    private void checkRelationOrderByHandler() {
        if (this.relationOrderByHandler == null) {
            this.relationOrderByHandler = new RelationOrderByHandler();
        }
    }

    private void checkRelationRowLimiterHandler() {
        if (this.relationRowLimiterHandler == null) {
            this.relationRowLimiterHandler = new RelationRowLimiterHandler();
        }
    }

    public RelationOrderByHandler getRelationOrderByHandler() {
        return this.relationOrderByHandler;
    }

    public void setRelationOrderByHandler(RelationOrderByHandler relationOrderByHandler) {
        this.relationOrderByHandler = relationOrderByHandler;
    }

    public RelationRowLimiterHandler getRelationRowLimiterHandler() {
        return this.relationRowLimiterHandler;
    }

    public void setRelationRowLimiterHandler(RelationRowLimiterHandler relationRowLimiterHandler) {
        this.relationRowLimiterHandler = relationRowLimiterHandler;
    }
}

