/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import se.unlogic.standardutils.dao.OrderByCriteria;
import se.unlogic.standardutils.dao.QueryParameter;
import se.unlogic.standardutils.dao.RelationQuery;
import se.unlogic.standardutils.dao.RowLimiter;

public class HighLevelQuery<T>
extends RelationQuery {
    private List<QueryParameter<T, ?>> parameters;
    private List<OrderByCriteria<T>> orderByCriterias;
    private RowLimiter rowLimiter;

    public HighLevelQuery() {
    }

    public HighLevelQuery(List<QueryParameter<T, ?>> parameters, List<OrderByCriteria<T>> orderByCriterias) {
        this.parameters = parameters;
        this.orderByCriterias = orderByCriterias;
    }

    public HighLevelQuery(Field ... relations) {
        this.addRelations(relations);
    }

    public HighLevelQuery(QueryParameter<T, ?> parameter, Field ... relations) {
        this.addParameter(parameter);
        this.addRelations(relations);
    }

    public HighLevelQuery(QueryParameter<T, ?>[] parameters) {
        this.addParameter(parameters);
    }

    public HighLevelQuery(RelationQuery relationQuery, Class<T> clazz) {
        super(relationQuery);
        List<OrderByCriteria<T>> relationOrderByCriterias;
        List<QueryParameter<T, ?>> relationParameters;
        if (this.getRelationParameterHandler() != null && (relationParameters = this.getRelationParameterHandler().getRelationParameters(clazz)) != null) {
            this.parameters = new ArrayList(relationParameters);
        }
        if (this.getRelationOrderByHandler() != null && (relationOrderByCriterias = this.getRelationOrderByHandler().getRelationOrderByCriterias(clazz)) != null) {
            this.orderByCriterias = new ArrayList<OrderByCriteria<T>>(relationOrderByCriterias);
        }
        if (this.getRelationRowLimiterHandler() != null) {
            this.rowLimiter = this.getRelationRowLimiterHandler().getRowLimitier(clazz);
        }
    }

    public void setParameters(List<QueryParameter<T, ?>> parameters) {
        this.parameters = parameters;
    }

    public synchronized void addParameter(QueryParameter<T, ?> parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(parameter);
    }

    public synchronized void addParameter(QueryParameter<T, ?> ... parameters) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.addAll(Arrays.asList(parameters));
    }

    public List<OrderByCriteria<T>> getOrderByCriterias() {
        return this.orderByCriterias;
    }

    public void setOrderByCriterias(List<OrderByCriteria<T>> orderByCriterias) {
        this.orderByCriterias = orderByCriterias;
    }

    public List<QueryParameter<T, ?>> getParameters() {
        return this.parameters;
    }

    public synchronized void addOrderByCriteria(OrderByCriteria<T> criteria) {
        if (this.orderByCriterias == null) {
            this.orderByCriterias = new ArrayList<OrderByCriteria<T>>();
        }
        this.orderByCriterias.add(criteria);
    }

    public synchronized void addOrderByCriteria(OrderByCriteria<T> ... criterias) {
        if (this.orderByCriterias == null) {
            this.orderByCriterias = new ArrayList<OrderByCriteria<T>>();
        }
        this.orderByCriterias.addAll(Arrays.asList(criterias));
    }

    @Override
    public HighLevelQuery<T> clone() {
        try {
            HighLevelQuery clone = (HighLevelQuery)super.clone();
            if (this.orderByCriterias != null) {
                clone.orderByCriterias = new ArrayList<OrderByCriteria<T>>(this.orderByCriterias);
            }
            if (this.parameters != null) {
                clone.parameters = new ArrayList(this.parameters);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public RowLimiter getRowLimiter() {
        return this.rowLimiter;
    }

    public void setRowLimiter(RowLimiter rowLimiter) {
        this.rowLimiter = rowLimiter;
    }
}

