/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.AnnotatedDAOFactory;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.OneToOneRelation;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.dao.RelationQuery;
import se.unlogic.standardutils.dao.RelationUtils;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.OneToOne;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.string.StringUtils;

public class DefaultOneToOneRelation<LocalType, RemoteType, LocalKeyType>
implements OneToOneRelation<LocalType, RemoteType> {
    private final Field field;
    private Field remoteField;
    private final Field localKeyField;
    private final Field remoteKeyField;
    private final AnnotatedDAOFactory daoFactory;
    private AnnotatedDAO<RemoteType> annotatedDAO;
    private QueryParameterFactory<RemoteType, LocalKeyType> queryParameterFactory;
    private final Class<RemoteType> remoteClass;
    private final Class<LocalKeyType> localKeyClass;
    private boolean initialized;
    private boolean preAdd;

    public DefaultOneToOneRelation(Class<LocalType> beanClass, Class<RemoteType> remoteClass, Class<LocalKeyType> localKeyClass, Field field, Field localKeyField, AnnotatedDAOFactory daoFactory, DAOManaged daoManaged) {
        this.remoteClass = remoteClass;
        this.field = field;
        this.daoFactory = daoFactory;
        this.localKeyField = localKeyField;
        this.localKeyClass = localKeyClass;
        ReflectionUtils.fixFieldAccess(this.localKeyField);
        List<Field> fields = ReflectionUtils.getFields(remoteClass);
        for (Field remoteField : fields) {
            if (!remoteField.getType().equals(beanClass) || !remoteField.isAnnotationPresent(DAOManaged.class) || !remoteField.isAnnotationPresent(OneToOne.class)) continue;
            this.remoteField = remoteField;
            ReflectionUtils.fixFieldAccess(this.remoteField);
            break;
        }
        if (this.remoteField == null) {
            throw new RuntimeException("Unable to to find corresponding @OneToOne field in class " + remoteClass + " for @OneToOne annotated field " + field.getName() + " in " + beanClass);
        }
        OneToOne localAnnotation = field.getAnnotation(OneToOne.class);
        OneToOne remoteAnnotation = this.remoteField.getAnnotation(OneToOne.class);
        this.remoteKeyField = DefaultOneToOneRelation.getKeyField(this.remoteField.getAnnotation(OneToOne.class), remoteClass, this.remoteField);
        if (!localKeyField.getType().equals(this.remoteKeyField.getType())) {
            throw new RuntimeException("Incompatible types between key field " + localKeyField.getName() + " in class " + beanClass + " and key field " + this.remoteKeyField.getName() + " in class " + remoteClass + ". @OneToOne annotation requires key fields to be of same type.");
        }
        if (localAnnotation.preAdd() && remoteAnnotation.preAdd()) {
            throw new RuntimeException("Invalid preAdd values for @OneToOne annotation on field " + field.getName() + " in class " + beanClass + " and field " + this.remoteField.getName() + " in class " + remoteClass + ". @OneToOne relations can only have preAdd set to true on one side of the relation.");
        }
        ReflectionUtils.fixFieldAccess(this.remoteKeyField);
        this.preAdd = localAnnotation.preAdd();
    }

    @Override
    public void getRemoteValue(LocalType bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        if (!this.initialized) {
            this.init();
        }
        try {
            HighLevelQuery<RemoteType> query = new HighLevelQuery<RemoteType>(relationQuery, this.remoteClass);
            query.addParameter(this.queryParameterFactory.getParameter(this.localKeyField.get(bean)));
            this.field.set(bean, this.annotatedDAO.get(query, connection));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void add(LocalType bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        if (!this.initialized) {
            this.init();
        }
        try {
            Object remoteBean = this.field.get(bean);
            if (remoteBean != null) {
                if (!this.preAdd) {
                    this.setRemoteKeyFieldValue(remoteBean, bean);
                }
                this.annotatedDAO.add(remoteBean, connection, relationQuery);
                if (this.preAdd) {
                    this.setLocalKeyFieldValue(bean, remoteBean);
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void setRemoteKeyFieldValue(RemoteType remoteBean, LocalType bean) throws IllegalArgumentException, IllegalAccessException {
        this.remoteKeyField.set(remoteBean, this.localKeyField.get(bean));
    }

    private void setLocalKeyFieldValue(LocalType bean, RemoteType remoteBean) throws IllegalArgumentException, IllegalAccessException {
        this.localKeyField.set(bean, this.remoteKeyField.get(remoteBean));
    }

    @Override
    public void update(LocalType bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        if (!this.initialized) {
            this.init();
        }
        try {
            Object remoteBean = this.field.get(bean);
            if (remoteBean != null) {
                if (!this.preAdd) {
                    this.setRemoteKeyFieldValue(remoteBean, bean);
                }
                this.annotatedDAO.addOrUpdate(remoteBean, connection, relationQuery);
                if (this.preAdd) {
                    this.setLocalKeyFieldValue(bean, remoteBean);
                }
            } else {
                HighLevelQuery<RemoteType> deleteQuery = new HighLevelQuery<RemoteType>(relationQuery, this.remoteClass);
                deleteQuery.addParameter(this.queryParameterFactory.getParameter(this.localKeyField.get(bean)));
                this.annotatedDAO.delete(deleteQuery, connection);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void init() {
        if (this.annotatedDAO == null) {
            this.annotatedDAO = this.daoFactory.getDAO(this.remoteClass);
            this.queryParameterFactory = this.annotatedDAO.getParamFactory(this.remoteKeyField, this.localKeyClass);
        }
        this.initialized = true;
    }

    public static Field getKeyField(OneToOne oneToOneAnnotation, Class<?> clazz, Field annotatedField) {
        if (!StringUtils.isEmpty(oneToOneAnnotation.keyField())) {
            try {
                Field keyField = clazz.getDeclaredField(oneToOneAnnotation.keyField());
                DAOManaged keyDAOPopulate = keyField.getAnnotation(DAOManaged.class);
                if (keyDAOPopulate == null) {
                    throw new RuntimeException("Specified keyField " + oneToOneAnnotation.keyField() + " for @OneToOne annotation for field " + annotatedField.getName() + "  in " + clazz + " is missing the @DAOManaged annotation");
                }
                return keyField;
            }
            catch (SecurityException e) {
                throw new RuntimeException("Unable to find specified keyField " + oneToOneAnnotation.keyField() + " for @OneToOne annotation for field " + annotatedField.getName() + "  in " + clazz);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Unable to find specified keyField " + oneToOneAnnotation.keyField() + " for @OneToOne annotation for field " + annotatedField.getName() + "  in " + clazz);
            }
        }
        ArrayList<Field> keyFields = RelationUtils.getKeyFields(clazz);
        if (keyFields.size() == 0) {
            throw new RuntimeException("Unable to find any @Key annotated fields in " + clazz);
        }
        if (keyFields.size() > 1) {
            throw new RuntimeException("keyField needs to be specified for @OneToOne annotated field " + annotatedField.getName() + " in " + clazz + " since the class contains multiple @Key annotated fields");
        }
        return keyFields.get(0);
    }

    public static <LT, RT, LKT> OneToOneRelation<LT, RT> getGenericInstance(Class<LT> beanClass, Class<RT> remoteClass, Class<LKT> localKeyClass, Field field, Field localKeyField, AnnotatedDAOFactory daoFactory, DAOManaged daoManaged) {
        return new DefaultOneToOneRelation<LT, RT, LKT>(beanClass, remoteClass, localKeyClass, field, localKeyField, daoFactory, daoManaged);
    }

    @Override
    public boolean preAdd() {
        return this.preAdd;
    }
}

