/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.AnnotatedDAOFactory;
import se.unlogic.standardutils.dao.Column;
import se.unlogic.standardutils.dao.CustomQueryParameter;
import se.unlogic.standardutils.dao.ManyToManyRelation;
import se.unlogic.standardutils.dao.RelationQuery;
import se.unlogic.standardutils.dao.RelationUtils;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.ManyToMany;
import se.unlogic.standardutils.dao.querys.UpdateQuery;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.string.StringUtils;

public class DefaultManyToManyRelation<LocalType, RemoteType>
implements ManyToManyRelation<LocalType, RemoteType> {
    private final Field field;
    private final Field localKeyField;
    private final Field remoteKeyField;
    private final String linkTable;
    private final String localLinkTableColumnName;
    private final String remoteKeyColumnName;
    private final String remoteLinkTableColumnName;
    private String linkTableLinkSQL;
    private String linkTableDeleteSQL;
    private String linkTableInsertSQL;
    private Column<LocalType, ?> localColumn;
    private Column<RemoteType, ?> remoteColumn;
    private final AnnotatedDAOFactory daoFactory;
    private AnnotatedDAO<RemoteType> annotatedDAO;
    private final Class<LocalType> beanClass;
    private final Class<RemoteType> remoteClass;
    private boolean initialized;

    public DefaultManyToManyRelation(Class<LocalType> beanClass, Class<RemoteType> remoteClass, Field field, AnnotatedDAOFactory daoFactory, DAOManaged daoManaged) {
        Field[] fields;
        this.beanClass = beanClass;
        this.remoteClass = remoteClass;
        this.field = field;
        this.daoFactory = daoFactory;
        ManyToMany localAnnotation = field.getAnnotation(ManyToMany.class);
        this.linkTable = localAnnotation.linkTable();
        Field matchingRemoteField = null;
        for (Field remoteField : fields = remoteClass.getDeclaredFields()) {
            if (ReflectionUtils.getGenericlyTypeCount(remoteField) != 1 || !ReflectionUtils.getGenericType(remoteField).equals(beanClass) || !remoteField.isAnnotationPresent(DAOManaged.class) || !remoteField.isAnnotationPresent(ManyToMany.class) || !remoteField.getAnnotation(ManyToMany.class).linkTable().equals(this.linkTable)) continue;
            matchingRemoteField = remoteField;
            break;
        }
        if (matchingRemoteField == null) {
            throw new RuntimeException("Unable to to find corresponding @ManyToMany field in " + remoteClass + " while parsing field " + field.getName() + " in " + beanClass);
        }
        ManyToMany remoteAnnotation = matchingRemoteField.getAnnotation(ManyToMany.class);
        this.localKeyField = DefaultManyToManyRelation.getKeyField(localAnnotation, beanClass, field);
        this.localLinkTableColumnName = DefaultManyToManyRelation.getColumnName(daoManaged, this.localKeyField);
        this.remoteKeyField = DefaultManyToManyRelation.getKeyField(remoteAnnotation, remoteClass, matchingRemoteField);
        this.remoteLinkTableColumnName = DefaultManyToManyRelation.getColumnName(this.remoteKeyField.getAnnotation(DAOManaged.class), this.remoteKeyField);
        String remoteColumnName = this.remoteKeyField.getAnnotation(DAOManaged.class).columnName();
        this.remoteKeyColumnName = !StringUtils.isEmpty(remoteColumnName) ? remoteColumnName : this.remoteKeyField.getName();
        this.linkTableDeleteSQL = "DELETE FROM " + this.linkTable + " WHERE " + this.localLinkTableColumnName + " = ?";
        this.linkTableInsertSQL = "INSERT INTO " + this.linkTable + " (" + this.localLinkTableColumnName + "," + this.remoteLinkTableColumnName + ") VALUES (?,?)";
    }

    @Override
    public void getRemoteValue(LocalType bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        try {
            CustomQueryParameter<LocalType> queryParameter;
            if (!this.initialized) {
                this.init();
            }
            if ((queryParameter = new CustomQueryParameter<LocalType>(this.localColumn, bean)).getParamValue() != null) {
                this.field.set(bean, this.annotatedDAO.getAll(this.linkTableLinkSQL, queryParameter, connection, relationQuery));
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void add(LocalType bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        try {
            List remoteBeans;
            if (!this.initialized) {
                this.init();
            }
            if ((remoteBeans = (List)this.field.get(bean)) == null) {
                return;
            }
            for (Object remoteBean : remoteBeans) {
                UpdateQuery insertQuery = new UpdateQuery(connection, false, this.linkTableInsertSQL);
                DefaultManyToManyRelation.setQueryParameter(insertQuery, this.localColumn, bean, 1);
                DefaultManyToManyRelation.setQueryParameter(insertQuery, this.remoteColumn, remoteBean, 2);
                insertQuery.executeUpdate();
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void update(LocalType bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        try {
            if (!this.initialized) {
                this.init();
            }
            UpdateQuery deleteQuery = new UpdateQuery(connection, false, this.linkTableDeleteSQL);
            DefaultManyToManyRelation.setQueryParameter(deleteQuery, this.localColumn, bean, 1);
            deleteQuery.executeUpdate();
            List remoteBeans = (List)this.field.get(bean);
            if (remoteBeans == null) {
                return;
            }
            for (Object remoteBean : remoteBeans) {
                UpdateQuery insertQuery = new UpdateQuery(connection, false, this.linkTableInsertSQL);
                DefaultManyToManyRelation.setQueryParameter(insertQuery, this.localColumn, bean, 1);
                DefaultManyToManyRelation.setQueryParameter(insertQuery, this.remoteColumn, remoteBean, 2);
                insertQuery.executeUpdate();
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void init() {
        if (this.annotatedDAO == null) {
            this.annotatedDAO = this.daoFactory.getDAO(this.remoteClass);
        }
        if (this.linkTableLinkSQL == null) {
            this.linkTableLinkSQL = "SELECT " + this.annotatedDAO.getTableName() + ".* FROM " + this.annotatedDAO.getTableName() + " INNER JOIN " + this.linkTable + " ON (" + this.annotatedDAO.getTableName() + "." + this.remoteKeyColumnName + "=" + this.linkTable + "." + this.remoteLinkTableColumnName + ") WHERE " + this.linkTable + "." + this.localLinkTableColumnName + " = ?";
        }
        if (this.localColumn == null) {
            this.localColumn = this.daoFactory.getDAO(this.beanClass).getColumn(this.localKeyField);
        }
        if (this.remoteColumn == null) {
            this.remoteColumn = this.annotatedDAO.getColumn(this.remoteKeyField);
        }
        this.initialized = true;
    }

    private static <Type> void setQueryParameter(UpdateQuery query, Column<Type, ?> column, Type bean, int index) throws SQLException {
        if (column.getQueryParameterPopulator() != null) {
            column.getQueryParameterPopulator().populate(query, index, column.getBeanValue(bean));
        } else {
            try {
                column.getQueryMethod().invoke((Object)query, index, column.getBeanValue(bean));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Field getKeyField(ManyToMany manyToManyAnnotation, Class<?> clazz, Field annotatedField) {
        if (!StringUtils.isEmpty(manyToManyAnnotation.keyField())) {
            try {
                Field keyField = clazz.getDeclaredField(manyToManyAnnotation.keyField());
                DAOManaged keyDAOPopulate = keyField.getAnnotation(DAOManaged.class);
                if (keyDAOPopulate == null) {
                    throw new RuntimeException("Specified keyField " + manyToManyAnnotation.keyField() + " for @ManyToMany annotation for field " + annotatedField.getName() + "  in " + clazz + " is missing the @DAOManaged annotation");
                }
                return keyField;
            }
            catch (SecurityException e) {
                throw new RuntimeException("Unable to find specified keyField " + manyToManyAnnotation.keyField() + " for @ManyToMany annotation for field " + annotatedField.getName() + "  in " + clazz);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Unable to find specified keyField " + manyToManyAnnotation.keyField() + " for @ManyToMany annotation for field " + annotatedField.getName() + "  in " + clazz);
            }
        }
        ArrayList<Field> keyFields = RelationUtils.getKeyFields(clazz);
        if (keyFields.size() == 0) {
            throw new RuntimeException("Unable to find any @Key annotated fields in " + clazz);
        }
        if (keyFields.size() > 1) {
            throw new RuntimeException("keyField needs to be specified for @ManyToMany annotated field " + annotatedField.getName() + " in " + clazz + " since the class contains multiple @Key annotated fields");
        }
        return keyFields.get(0);
    }

    private static String getColumnName(DAOManaged manyToManyDAOPopulate, Field keyField) {
        if (!StringUtils.isEmpty(manyToManyDAOPopulate.columnName())) {
            return manyToManyDAOPopulate.columnName();
        }
        String keyColumnName = keyField.getAnnotation(DAOManaged.class).columnName();
        if (!StringUtils.isEmpty(keyColumnName)) {
            return keyColumnName;
        }
        return keyField.getName();
    }

    public static <LT, RT> ManyToManyRelation<LT, RT> getGenericInstance(Class<LT> beanClass, Class<RT> remoteClass, Field field, AnnotatedDAOFactory daoFactory, DAOManaged daoManaged) {
        return new DefaultManyToManyRelation<LT, RT>(beanClass, remoteClass, field, daoFactory, daoManaged);
    }
}

