/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao;

import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.CRUDDAO;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.dao.RelationQuery;
import se.unlogic.standardutils.dao.TransactionHandler;

public class AnnotatedDAOWrapper<BeanType, KeyType>
implements CRUDDAO<BeanType, KeyType> {
    protected final HighLevelQuery<BeanType> DISABLED_AUTO_RELATIONS_QUERY = new HighLevelQuery();
    protected AnnotatedDAO<BeanType> annotatedDAO;
    protected QueryParameterFactory<BeanType, KeyType> parameterFactory;
    protected ArrayList<Field> relations = new ArrayList();
    protected RelationQuery relationQuery;
    protected boolean useRelationsOnAdd;
    protected boolean useRelationsOnUpdate;
    protected boolean useRelationsOnGet;
    protected boolean useRelationsOnGetAll;
    protected boolean disableAutoRelations;

    public AnnotatedDAOWrapper(AnnotatedDAO<BeanType> annotatedDAO, String keyField, Class<KeyType> keyClass) {
        this.annotatedDAO = annotatedDAO;
        this.parameterFactory = annotatedDAO.getParamFactory(keyField, keyClass);
    }

    public AnnotatedDAOWrapper(AnnotatedDAO<BeanType> annotatedDAO, Field keyField, Class<KeyType> keyClass) {
        this.annotatedDAO = annotatedDAO;
        this.parameterFactory = annotatedDAO.getParamFactory(keyField, keyClass);
    }

    @Override
    public List<BeanType> getAll() throws SQLException {
        return this.getAll(null);
    }

    @Override
    public List<BeanType> getAll(TransactionHandler transactionHandler) throws SQLException {
        HighLevelQuery<BeanType> query = this.getGetAllQuery();
        if (transactionHandler != null) {
            return this.annotatedDAO.getAll(query, transactionHandler);
        }
        return this.annotatedDAO.getAll(query);
    }

    @Override
    public void add(BeanType bean) throws SQLException {
        this.add(bean, null);
    }

    @Override
    public void add(BeanType bean, TransactionHandler transactionHandler) throws SQLException {
        RelationQuery relationQuery = this.getUpdateQuery();
        if (transactionHandler != null) {
            this.annotatedDAO.add(bean, transactionHandler, relationQuery);
        } else {
            this.annotatedDAO.add(bean, relationQuery);
        }
    }

    @Override
    public void delete(BeanType bean) throws SQLException {
        this.annotatedDAO.delete(bean);
    }

    @Override
    public void delete(BeanType bean, TransactionHandler transactionHandler) throws SQLException {
        this.annotatedDAO.delete(bean, transactionHandler);
    }

    public Integer deleteByID(KeyType beanID) throws SQLException {
        return this.deleteByID(beanID, null);
    }

    public Integer deleteByID(KeyType beanID, TransactionHandler transactionHandler) throws SQLException {
        HighLevelQuery<BeanType> query = this.getGetQuery(beanID);
        if (transactionHandler != null) {
            return this.annotatedDAO.delete(query, transactionHandler);
        }
        return this.annotatedDAO.delete(query);
    }

    @Override
    public BeanType get(KeyType beanID) throws SQLException {
        return this.get(beanID, (TransactionHandler)null);
    }

    @Override
    public BeanType get(KeyType beanID, TransactionHandler transactionHandler) throws SQLException {
        HighLevelQuery<BeanType> query = this.getGetQuery(beanID);
        if (transactionHandler != null) {
            return this.annotatedDAO.get(query, transactionHandler);
        }
        return this.annotatedDAO.get(query);
    }

    @Override
    public void update(BeanType bean) throws SQLException {
        this.update(bean, null);
    }

    @Override
    public void update(BeanType bean, TransactionHandler transactionHandler) throws SQLException {
        RelationQuery relationQuery = this.getUpdateQuery();
        if (transactionHandler != null) {
            this.annotatedDAO.update(bean, transactionHandler, relationQuery);
        } else {
            this.annotatedDAO.update(bean, relationQuery);
        }
    }

    private HighLevelQuery<BeanType> getGetAllQuery() {
        if (this.useRelationsOnGetAll && !this.relations.isEmpty()) {
            HighLevelQuery query = new HighLevelQuery();
            query.addRelations(this.relations);
            query.disableAutoRelations(this.disableAutoRelations);
            return query;
        }
        if (this.disableAutoRelations) {
            return this.DISABLED_AUTO_RELATIONS_QUERY;
        }
        return null;
    }

    private HighLevelQuery<BeanType> getGetQuery(KeyType value) {
        HighLevelQuery<BeanType> query = new HighLevelQuery<BeanType>();
        if (this.useRelationsOnGet && !this.relations.isEmpty()) {
            query.addRelations(this.relations);
        }
        if (this.disableAutoRelations) {
            query.disableAutoRelations(this.disableAutoRelations);
        }
        query.addParameter(this.parameterFactory.getParameter(value));
        return query;
    }

    private RelationQuery getUpdateQuery() {
        if (this.useRelationsOnAdd && this.relationQuery != null) {
            return this.relationQuery;
        }
        if (this.disableAutoRelations) {
            return this.DISABLED_AUTO_RELATIONS_QUERY;
        }
        return null;
    }

    public void addRelation(Field field) {
        this.relations.add(field);
        this.relationQuery = new RelationQuery(this.relations);
        this.relationQuery.disableAutoRelations(this.disableAutoRelations);
    }

    public void addRelations(Field ... fields) {
        this.relations.addAll(Arrays.asList(fields));
        this.relationQuery = new RelationQuery(this.relations);
        this.relationQuery.disableAutoRelations(this.disableAutoRelations);
    }

    public boolean isUseRelationsOnAdd() {
        return this.useRelationsOnAdd;
    }

    public void setUseRelationsOnAdd(boolean useRelationsOnAdd) {
        this.useRelationsOnAdd = useRelationsOnAdd;
    }

    public boolean isUseRelationsOnUpdate() {
        return this.useRelationsOnUpdate;
    }

    public void setUseRelationsOnUpdate(boolean useRelationsOnUpdate) {
        this.useRelationsOnUpdate = useRelationsOnUpdate;
    }

    public boolean isUseRelationsOnGet() {
        return this.useRelationsOnGet;
    }

    public void setUseRelationsOnGet(boolean useRelationsOnGet) {
        this.useRelationsOnGet = useRelationsOnGet;
    }

    public AnnotatedDAO<BeanType> getAnnotatedDAO() {
        return this.annotatedDAO;
    }

    public boolean isUseRelationsOnGetAll() {
        return this.useRelationsOnGetAll;
    }

    public void setUseRelationsOnGetAll(boolean useRelationsOnGetAll) {
        this.useRelationsOnGetAll = useRelationsOnGetAll;
    }

    public QueryParameterFactory<BeanType, KeyType> getParameterFactory() {
        return this.parameterFactory;
    }

    public TransactionHandler createTransaction() throws SQLException {
        return this.annotatedDAO.createTransaction();
    }

    public boolean isDisableAutoRelations() {
        return this.disableAutoRelations;
    }

    public void disableAutoRelations(boolean disableAutoRelations) {
        this.disableAutoRelations = disableAutoRelations;
        if (this.relationQuery != null) {
            this.relationQuery.disableAutoRelations(disableAutoRelations);
        }
    }
}

