/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import se.unlogic.standardutils.annotations.UnsupportedFieldTypeException;
import se.unlogic.standardutils.bool.BooleanSignal;
import se.unlogic.standardutils.dao.AdvancedAnnotatedDAOWrapper;
import se.unlogic.standardutils.dao.AnnotatedDAOFactory;
import se.unlogic.standardutils.dao.AnnotatedDAOWrapper;
import se.unlogic.standardutils.dao.BeanChainPopulator;
import se.unlogic.standardutils.dao.BeanRelationPopulator;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.dao.Column;
import se.unlogic.standardutils.dao.ColumnKeyCollector;
import se.unlogic.standardutils.dao.ColumnKeyCollectorWrapper;
import se.unlogic.standardutils.dao.CustomQueryParameter;
import se.unlogic.standardutils.dao.DefaultManyToManyRelation;
import se.unlogic.standardutils.dao.DefaultManyToOneRelation;
import se.unlogic.standardutils.dao.DefaultOneToManyRelation;
import se.unlogic.standardutils.dao.DefaultOneToOneRelation;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.LowLevelQuery;
import se.unlogic.standardutils.dao.ManyToManyRelation;
import se.unlogic.standardutils.dao.ManyToOneRelation;
import se.unlogic.standardutils.dao.OneToManyRelation;
import se.unlogic.standardutils.dao.OneToOneRelation;
import se.unlogic.standardutils.dao.OrderByComparator;
import se.unlogic.standardutils.dao.OrderByCriteria;
import se.unlogic.standardutils.dao.PreparedStatementQueryMethods;
import se.unlogic.standardutils.dao.QueryParameter;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.dao.RelationQuery;
import se.unlogic.standardutils.dao.SimpleColumn;
import se.unlogic.standardutils.dao.SimplifiedOneToManyRelation;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.Key;
import se.unlogic.standardutils.dao.annotations.ManyToMany;
import se.unlogic.standardutils.dao.annotations.ManyToOne;
import se.unlogic.standardutils.dao.annotations.OneToMany;
import se.unlogic.standardutils.dao.annotations.OneToOne;
import se.unlogic.standardutils.dao.annotations.OrderBy;
import se.unlogic.standardutils.dao.annotations.SimplifiedRelation;
import se.unlogic.standardutils.dao.annotations.Table;
import se.unlogic.standardutils.dao.querys.ArrayListQuery;
import se.unlogic.standardutils.dao.querys.BooleanQuery;
import se.unlogic.standardutils.dao.querys.ObjectQuery;
import se.unlogic.standardutils.dao.querys.PreparedStatementQuery;
import se.unlogic.standardutils.dao.querys.UpdateQuery;
import se.unlogic.standardutils.datatypes.SimpleEntry;
import se.unlogic.standardutils.db.DBUtils;
import se.unlogic.standardutils.enums.Order;
import se.unlogic.standardutils.numbers.IntegerCounter;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.populators.EnumPopulator;
import se.unlogic.standardutils.populators.IntegerPopulator;
import se.unlogic.standardutils.populators.QueryParameterPopulator;
import se.unlogic.standardutils.populators.QueryParameterPopulatorRegistery;
import se.unlogic.standardutils.populators.annotated.AnnotatedResultSetPopulator;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.string.StringUtils;

public class AnnotatedDAO<T> {
    private static final OrderByComparator ORDER_BY_COMPARATOR = new OrderByComparator();
    protected final AnnotatedResultSetPopulator<T> populator;
    protected final DataSource dataSource;
    protected final Class<T> beanClass;
    protected final List<QueryParameterPopulator<?>> queryParameterPopulators;
    protected final ArrayList<Column<T, ?>> simpleKeys = new ArrayList();
    protected final ArrayList<Column<T, ?>> simpleColumns = new ArrayList();
    protected final HashMap<Field, Column<T, ?>> columnMap = new HashMap();
    protected final ArrayList<ColumnKeyCollector<T>> columnKeyCollectors = new ArrayList();
    protected final HashMap<Field, ManyToOneRelation<T, ?, ?>> manyToOneRelations = new HashMap();
    protected final HashMap<Field, ManyToOneRelation<T, ?, ?>> manyToOneRelationKeys = new HashMap();
    protected final HashMap<Field, OneToManyRelation<T, ?>> oneToManyRelations = new HashMap();
    protected final HashMap<Field, OneToOneRelation<T, ?>> oneToOneRelations = new HashMap();
    protected final HashMap<Field, ManyToManyRelation<T, ?>> manyToManyRelations = new HashMap();
    protected final ArrayList<Map.Entry<OrderBy, Column<T, ?>>> columnOrderList = new ArrayList();
    protected final ArrayList<Field> autoAddRelations = new ArrayList();
    protected final ArrayList<Field> autoGetRelations = new ArrayList();
    protected final ArrayList<Field> autoUpdateRelations = new ArrayList();
    protected final ArrayList<SimpleColumn<T, ?>> dontUpdateIfNullCoulumns = new ArrayList();
    protected String tableName;
    protected String insertSQL;
    protected String updateSQL;
    protected String deleteSQL;
    protected String checkIfExistsSQL;
    protected String deleteByFieldSQL;
    protected String getSQL;
    protected String booleanSQL;
    protected String defaultSortingCriteria;

    public AnnotatedDAO(DataSource dataSource, Class<T> beanClass, AnnotatedDAOFactory daoFactory) {
        this(dataSource, beanClass, daoFactory, new AnnotatedResultSetPopulator<T>(beanClass), (List<QueryParameterPopulator<?>>)null, (List<BeanStringPopulator<?>>)null);
    }

    public AnnotatedDAO(DataSource dataSource, Class<T> beanClass, AnnotatedDAOFactory daoFactory, AnnotatedResultSetPopulator<T> populator, QueryParameterPopulator<?> ... queryParameterPopulators) {
        this(dataSource, beanClass, daoFactory, populator, Arrays.asList(queryParameterPopulators), null);
    }

    public AnnotatedDAO(DataSource dataSource, Class<T> beanClass, AnnotatedDAOFactory daoFactory, List<? extends QueryParameterPopulator<?>> queryParameterPopulators, List<? extends BeanStringPopulator<?>> typePopulators) {
        this(dataSource, beanClass, daoFactory, new AnnotatedResultSetPopulator<T>(beanClass, typePopulators), queryParameterPopulators, typePopulators);
    }

    /*
     * WARNING - void declaration
     */
    public AnnotatedDAO(DataSource dataSource, Class<T> beanClass, AnnotatedDAOFactory daoFactory, AnnotatedResultSetPopulator<T> populator, List<? extends QueryParameterPopulator<?>> queryParameterPopulators, List<? extends BeanStringPopulator<?>> typePopulators) {
        this.populator = populator;
        this.dataSource = dataSource;
        this.beanClass = beanClass;
        this.queryParameterPopulators = queryParameterPopulators != null ? new ArrayList(queryParameterPopulators) : null;
        Table table = beanClass.getAnnotation(Table.class);
        if (table == null) {
            throw new RuntimeException("No @Table annotation found in  " + beanClass);
        }
        this.tableName = table.name();
        this.tableName = table.name();
        List<Field> fields = ReflectionUtils.getFields(beanClass);
        int generatedKeyColumnIndex = 1;
        for (Field field : fields) {
            String columnName;
            DAOManaged daoManaged = field.getAnnotation(DAOManaged.class);
            OrderBy orderBy = field.getAnnotation(OrderBy.class);
            if (daoManaged == null) continue;
            ReflectionUtils.fixFieldAccess(field);
            if (field.isAnnotationPresent(OneToOne.class)) {
                this.checkAutoGeneration(field, daoManaged);
                this.checkOrderByAnnotation(field, orderBy);
                OneToOne oneToOne = field.getAnnotation(OneToOne.class);
                Field localKeyField = DefaultOneToOneRelation.getKeyField(oneToOne, beanClass, field);
                this.oneToOneRelations.put(field, DefaultOneToOneRelation.getGenericInstance(beanClass, field.getType(), localKeyField.getType(), field, localKeyField, daoFactory, daoManaged));
                if (oneToOne.autoAdd()) {
                    this.autoAddRelations.add(field);
                }
                if (oneToOne.autoUpdate()) {
                    this.autoUpdateRelations.add(field);
                }
                if (!oneToOne.autoGet()) continue;
                this.autoGetRelations.add(field);
                continue;
            }
            if (field.isAnnotationPresent(OneToMany.class)) {
                OneToMany oneToMany = field.getAnnotation(OneToMany.class);
                this.checkOrderByAnnotation(field, orderBy);
                if (field.getType() != List.class) {
                    throw new UnsupportedFieldTypeException("The annotated field " + field.getName() + " in  " + beanClass + " is of unsupported type " + field.getType() + ". Fields annotated as @OneToMany have to be a genericly typed " + List.class, field, OneToMany.class, beanClass);
                }
                if (ReflectionUtils.getGenericlyTypeCount(field) != 1) {
                    throw new UnsupportedFieldTypeException("The annotated field " + field.getName() + " in  " + beanClass + " is genericly typed. Fields annotated as @OneToMany have to be a genericly typed " + List.class, field, OneToMany.class, beanClass);
                }
                Class remoteClass = (Class)ReflectionUtils.getGenericType(field);
                SimplifiedRelation simplifiedRelation = field.getAnnotation(SimplifiedRelation.class);
                if (simplifiedRelation != null) {
                    this.oneToManyRelations.put(field, SimplifiedOneToManyRelation.getGenericInstance(beanClass, remoteClass, field, this, typePopulators, queryParameterPopulators));
                } else {
                    this.oneToManyRelations.put(field, DefaultOneToManyRelation.getGenericInstance(beanClass, remoteClass, field, daoFactory, daoManaged));
                }
                if (oneToMany.autoAdd()) {
                    this.autoAddRelations.add(field);
                }
                if (oneToMany.autoUpdate()) {
                    this.autoUpdateRelations.add(field);
                }
                if (!oneToMany.autoGet()) continue;
                this.autoGetRelations.add(field);
                continue;
            }
            if (field.isAnnotationPresent(ManyToOne.class)) {
                void var18_26;
                this.checkAutoGeneration(field, daoManaged);
                ManyToOne manyToOne = field.getAnnotation(ManyToOne.class);
                List<Field> remoteClassFields = ReflectionUtils.getFields(field.getType());
                Field matchingRemoteField = null;
                if (remoteClassFields != null) {
                    for (Field field2 : remoteClassFields) {
                        if (!field2.isAnnotationPresent(DAOManaged.class) || !field2.isAnnotationPresent(OneToMany.class) || field2.getType() != List.class || !ReflectionUtils.isGenericlyTyped(field2) || (Class)ReflectionUtils.getGenericType(field2) != this.beanClass) continue;
                        matchingRemoteField = field2;
                        break;
                    }
                }
                if (matchingRemoteField == null) {
                    throw new RuntimeException("No corresponding @OneToMany annotated field found in  " + field.getType() + " matching @ManyToOne relation of field " + field.getName() + " in  " + beanClass + "!");
                }
                Field remoteKeyField = null;
                if (!StringUtils.isEmpty(manyToOne.remoteKeyField())) {
                    remoteKeyField = ReflectionUtils.getField(field.getType(), manyToOne.remoteKeyField());
                    if (remoteKeyField == null) {
                        throw new RuntimeException("Unable to find @Key annotated field " + manyToOne.remoteKeyField() + " in " + field.getType() + " specified for @ManyToOne annotated field " + field.getName() + " in " + beanClass);
                    }
                } else {
                    for (Field remoteField2 : remoteClassFields) {
                        if (!remoteField2.isAnnotationPresent(DAOManaged.class) || !remoteField2.isAnnotationPresent(Key.class)) continue;
                        if (remoteKeyField != null) {
                            throw new RuntimeException("Found multiple @Key annotated fields in " + field.getType() + ", therefore the remoteKeyField property needs to be specified for the @ManyToOne annotated field " + field.getName() + " in " + beanClass);
                        }
                        remoteKeyField = remoteField2;
                    }
                    if (remoteKeyField == null) {
                        throw new RuntimeException("Unable to find @Key annotated field in " + field.getType() + " while parsing @ManyToOne annotated field " + field.getName() + " in " + beanClass);
                    }
                }
                Object var18_23 = null;
                if (field.isAnnotationPresent(Key.class)) {
                    DefaultManyToOneRelation<T, ?, ?> defaultManyToOneRelation = DefaultManyToOneRelation.getGenericInstance(beanClass, field.getType(), remoteKeyField.getType(), field, remoteKeyField, daoManaged, daoFactory);
                    this.manyToOneRelationKeys.put(field, defaultManyToOneRelation);
                } else {
                    DefaultManyToOneRelation<T, ?, ?> defaultManyToOneRelation = DefaultManyToOneRelation.getGenericInstance(beanClass, field.getType(), remoteKeyField.getType(), field, remoteKeyField, daoManaged, daoFactory);
                    this.manyToOneRelations.put(field, defaultManyToOneRelation);
                }
                this.columnMap.put(field, (Column<T, ?>)var18_26);
                if (orderBy != null) {
                    this.columnOrderList.add(new SimpleEntry<OrderBy, void>(orderBy, var18_26));
                }
                if (manyToOne.autoAdd()) {
                    this.autoAddRelations.add(field);
                }
                if (manyToOne.autoUpdate()) {
                    this.autoUpdateRelations.add(field);
                }
                if (!manyToOne.autoGet()) continue;
                this.autoGetRelations.add(field);
                continue;
            }
            if (field.isAnnotationPresent(ManyToMany.class)) {
                this.checkAutoGeneration(field, daoManaged);
                this.checkOrderByAnnotation(field, orderBy);
                if (field.getType() != List.class) {
                    throw new UnsupportedFieldTypeException("The annotated field " + field.getName() + " in  " + beanClass + " is of unsupported type " + field.getType() + ". Fields annotated as @ManyToMany have to be a genericly typed " + List.class, field, ManyToMany.class, beanClass);
                }
                if (ReflectionUtils.getGenericlyTypeCount(field) != 1) {
                    throw new UnsupportedFieldTypeException("The annotated field " + field.getName() + " in  " + beanClass + " is genericly typed. Fields annotated as @ManyToMany have to be a genericly typed " + List.class, field, ManyToMany.class, beanClass);
                }
                Class remoteClass = (Class)ReflectionUtils.getGenericType(field);
                this.manyToManyRelations.put(field, DefaultManyToManyRelation.getGenericInstance(beanClass, remoteClass, field, daoFactory, daoManaged));
                ManyToMany manyToMany = field.getAnnotation(ManyToMany.class);
                if (manyToMany.autoAdd()) {
                    this.autoAddRelations.add(field);
                }
                if (manyToMany.autoUpdate()) {
                    this.autoUpdateRelations.add(field);
                }
                if (!manyToMany.autoGet()) continue;
                this.autoGetRelations.add(field);
                continue;
            }
            QueryParameterPopulator<?> queryPopulator = this.getQueryParameterPopulator(field.getType());
            Method method = null;
            if (queryPopulator == null) {
                method = PreparedStatementQueryMethods.getQueryMethod(field.getType());
                if (method == null && field.getType().isEnum()) {
                    queryPopulator = EnumPopulator.getInstanceFromField(field);
                }
                if (method == null && queryPopulator == null) {
                    throw new RuntimeException("No query method or query parameter populator found for @DAOManaged annotate field " + field.getName() + " in  " + beanClass);
                }
            }
            if (StringUtils.isEmpty(columnName = daoManaged.columnName())) {
                columnName = field.getName();
            }
            SimpleColumn<T, ?> simpleColumn = null;
            Key key = field.getAnnotation(Key.class);
            if (key != null) {
                simpleColumn = SimpleColumn.getGenericInstance(beanClass, field.getType(), field, method, queryPopulator, columnName, daoManaged.autoGenerated());
                this.simpleKeys.add(simpleColumn);
            } else {
                simpleColumn = SimpleColumn.getGenericInstance(beanClass, field.getType(), field, method, queryPopulator, columnName, daoManaged.autoGenerated());
                this.simpleColumns.add(simpleColumn);
                if (daoManaged.dontUpdateIfNull()) {
                    this.dontUpdateIfNullCoulumns.add(simpleColumn);
                }
            }
            this.columnMap.put(field, simpleColumn);
            if (daoManaged.autoGenerated()) {
                if (daoManaged.autGenerationColumnIndex() != 0) {
                    this.columnKeyCollectors.add(new ColumnKeyCollector<T>(field, populator, daoManaged.autGenerationColumnIndex()));
                } else {
                    this.columnKeyCollectors.add(new ColumnKeyCollector<T>(field, populator, generatedKeyColumnIndex));
                    ++generatedKeyColumnIndex;
                }
            }
            if (orderBy == null) continue;
            this.columnOrderList.add(new SimpleEntry(orderBy, simpleColumn));
        }
        if (this.simpleKeys.isEmpty() && this.manyToOneRelationKeys.isEmpty()) {
            throw new RuntimeException("No @Key annotated field found in  " + beanClass + "!");
        }
        this.generateInsertSQL();
        this.generateUpdateSQL();
        this.generateDeleteSQL();
        this.generateCheckIfExistsSQL();
        this.generateDeleteByFieldSQL();
        this.generateDefaultGetSQL();
        this.generateDefaultSortingCriteria();
        this.generateBooleanSQL();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    private void checkAutoGeneration(Field field, DAOManaged daoManaged) {
        if (daoManaged.autoGenerated()) {
            throw new RuntimeException("Invalid @DAOManaged annotation on field " + field.getName() + " in " + this.beanClass + ", fields with relations cannot be auto generated!");
        }
    }

    public <QPT> QueryParameterPopulator<QPT> getQueryParameterPopulator(Class<QPT> type) {
        if (this.queryParameterPopulators != null) {
            for (QueryParameterPopulator<?> queryParameterPopulator : this.queryParameterPopulators) {
                if (!type.equals(queryParameterPopulator.getType())) continue;
                return queryParameterPopulator;
            }
        }
        for (QueryParameterPopulator<?> queryParameterPopulator : QueryParameterPopulatorRegistery.getQueryParameterPopulators()) {
            if (!type.equals(queryParameterPopulator.getType())) continue;
            return queryParameterPopulator;
        }
        return null;
    }

    private void checkOrderByAnnotation(Field field, OrderBy orderBy) {
        if (orderBy != null) {
            throw new RuntimeException("Invalid @OrderBy annotation on field " + field.getName() + " in " + this.beanClass + ", the @OrderBy annotation is not allowed on @OneToOne, @OneToMany and @ManyToMany annotated fields.");
        }
    }

    private void generateDefaultSortingCriteria() {
        if (!this.columnOrderList.isEmpty()) {
            Collections.sort(this.columnOrderList, ORDER_BY_COMPARATOR);
            StringBuilder stringBuilder = new StringBuilder(" ORDER BY ");
            boolean first = true;
            for (Map.Entry<OrderBy, Column<T, ?>> entry : this.columnOrderList) {
                if (first) {
                    first = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(entry.getValue().getColumnName() + " " + entry.getKey().order().toString());
            }
            this.defaultSortingCriteria = stringBuilder.toString();
        } else {
            this.defaultSortingCriteria = "";
        }
    }

    protected void generateInsertSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT INTO " + this.tableName + " (");
        boolean first = true;
        for (Column<T, ?> column : this.columnMap.values()) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(column.getColumnName());
        }
        stringBuilder.append(") VALUES (");
        first = true;
        for (Column<T, ?> column : this.columnMap.values()) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append("?");
        }
        stringBuilder.append(")");
        this.insertSQL = stringBuilder.toString();
    }

    protected void generateUpdateSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE " + this.tableName + " SET ");
        boolean first = true;
        for (Column<T, ?> column : this.columnMap.values()) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(column.getColumnName() + " = ?");
        }
        stringBuilder.append(" WHERE ");
        this.appendPrimaryKeyWhereStatement(stringBuilder);
        this.updateSQL = stringBuilder.toString();
    }

    protected void generateCheckIfExistsSQL() {
        StringBuilder stringBuilder = new StringBuilder("SELECT 1 FROM " + this.tableName + " WHERE ");
        this.appendPrimaryKeyWhereStatement(stringBuilder);
        this.checkIfExistsSQL = stringBuilder.toString();
    }

    private void appendPrimaryKeyWhereStatement(StringBuilder stringBuilder) {
        boolean first = true;
        for (Column<T, ?> column : this.simpleKeys) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(column.getColumnName() + " = ?");
        }
        for (Column<T, ?> column : this.manyToOneRelationKeys.values()) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(column.getColumnName() + " = ?");
        }
    }

    protected void generateDeleteSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DELETE FROM ");
        stringBuilder.append(this.tableName);
        stringBuilder.append(" WHERE ");
        this.appendPrimaryKeyWhereStatement(stringBuilder);
        this.deleteSQL = stringBuilder.toString();
    }

    protected void generateDeleteByFieldSQL() {
        this.deleteByFieldSQL = "DELETE FROM " + this.tableName;
    }

    protected void generateBooleanSQL() {
        this.booleanSQL = "SELECT 1 FROM " + this.tableName;
    }

    protected void generateDefaultGetSQL() {
        this.getSQL = "SELECT * FROM " + this.tableName;
    }

    protected String generateGetSQL(HighLevelQuery<T> query) {
        if (!RelationQuery.hasExcludedFields(query)) {
            return this.getSQL;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        boolean first = true;
        for (Column<T, ?> column : this.columnMap.values()) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            if (query.containsExcludedField(column.getBeanField())) {
                stringBuilder.append("NULL AS " + column.getColumnName());
                continue;
            }
            stringBuilder.append(column.getColumnName());
        }
        stringBuilder.append(" FROM " + this.tableName);
        return stringBuilder.toString();
    }

    protected String generateUpdateSQL(RelationQuery query, T bean) {
        if (!RelationQuery.hasExcludedFields(query) && this.dontUpdateIfNullCoulumns.isEmpty()) {
            return this.updateSQL;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE " + this.tableName + " SET ");
        boolean first = true;
        for (Column<T, ?> column : this.columnMap.values()) {
            if (query != null && query.containsExcludedField(column.getBeanField()) || this.dontUpdateIfNullCoulumns.contains(column) && column.getBeanValue(bean) == null) continue;
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(column.getColumnName() + " = ?");
        }
        stringBuilder.append(" WHERE ");
        this.appendPrimaryKeyWhereStatement(stringBuilder);
        return stringBuilder.toString();
    }

    public TransactionHandler createTransaction() throws SQLException {
        return new TransactionHandler(this.dataSource);
    }

    public void add(T bean) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            this.add(bean, transactionHandler.getConnection(), null);
            transactionHandler.commit();
        }
        catch (Throwable throwable) {
            TransactionHandler.autoClose(transactionHandler);
            throw throwable;
        }
        TransactionHandler.autoClose(transactionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T bean, RelationQuery relationQuery) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            this.add(bean, transactionHandler.getConnection(), relationQuery);
            transactionHandler.commit();
        }
        catch (Throwable throwable) {
            TransactionHandler.autoClose(transactionHandler);
            throw throwable;
        }
        TransactionHandler.autoClose(transactionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection<T> beans, RelationQuery relationQuery) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            this.addAll(beans, transactionHandler.getConnection(), relationQuery);
            transactionHandler.commit();
        }
        catch (Throwable throwable) {
            TransactionHandler.autoClose(transactionHandler);
            throw throwable;
        }
        TransactionHandler.autoClose(transactionHandler);
    }

    public void add(T bean, TransactionHandler transactionHandler, RelationQuery relationQuery) throws SQLException {
        this.add(bean, transactionHandler.getConnection(), relationQuery);
    }

    public void addAll(List<T> beans, TransactionHandler transactionHandler, RelationQuery relationQuery) throws SQLException {
        this.addAll(beans, transactionHandler.getConnection(), relationQuery);
    }

    public void addAll(Collection<T> beans, Connection connection, RelationQuery relationQuery) throws SQLException {
        for (T bean : beans) {
            this.add(bean, connection, relationQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        this.preAddRelations(bean, connection, relationQuery);
        UpdateQuery query = null;
        try {
            query = new UpdateQuery(connection, false, this.insertSQL);
            IntegerCounter integerCounter = new IntegerCounter();
            this.setQueryValues(bean, query, null, integerCounter, this.columnMap.values(), false);
            this.executeUpdateQuery(query, bean);
            this.addRelations(bean, connection, relationQuery);
        }
        catch (Throwable throwable) {
            PreparedStatementQuery.autoCloseQuery(query);
            throw throwable;
        }
        PreparedStatementQuery.autoCloseQuery(query);
    }

    private void executeUpdateQuery(UpdateQuery query, T bean) throws SQLException {
        if (!this.columnKeyCollectors.isEmpty()) {
            query.executeUpdate(new ColumnKeyCollectorWrapper<T>(this.columnKeyCollectors, bean));
        } else {
            query.executeUpdate();
        }
    }

    private void preAddRelations(T bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        if (RelationQuery.hasRelations(relationQuery)) {
            for (Field relation : relationQuery.getRelations()) {
                this.preAddRelation(bean, connection, relationQuery, relation);
            }
        }
        if (relationQuery == null || !relationQuery.isDisableAutoRelations()) {
            for (Field relation : this.autoAddRelations) {
                if (relationQuery != null && (relationQuery.containsRelation(relation) || relationQuery.containsExcludedRelation(relation))) continue;
                this.preAddRelation(bean, connection, relationQuery, relation);
            }
        }
    }

    private void preAddRelation(T bean, Connection connection, RelationQuery relationQuery, Field relation) throws SQLException {
        ManyToOneRelation<T, ?, ?> manyToOneRelation = this.manyToOneRelations.get(relation);
        if (manyToOneRelation != null) {
            manyToOneRelation.add(bean, connection, relationQuery);
            return;
        }
        manyToOneRelation = this.manyToOneRelationKeys.get(relation);
        if (manyToOneRelation != null) {
            manyToOneRelation.add(bean, connection, relationQuery);
            return;
        }
        OneToOneRelation<T, ?> oneToOneRelation = this.oneToOneRelations.get(relation);
        if (oneToOneRelation != null && oneToOneRelation.preAdd()) {
            oneToOneRelation.add(bean, connection, relationQuery);
            return;
        }
    }

    private void addRelations(T bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        if (RelationQuery.hasRelations(relationQuery)) {
            for (Field relation : relationQuery.getRelations()) {
                this.addRelation(bean, connection, relationQuery, relation);
            }
        }
        if (relationQuery == null || !relationQuery.isDisableAutoRelations()) {
            for (Field relation : this.autoAddRelations) {
                if (relationQuery != null && (relationQuery.containsRelation(relation) || relationQuery.containsExcludedRelation(relation))) continue;
                this.addRelation(bean, connection, relationQuery, relation);
            }
        }
    }

    private void addRelation(T bean, Connection connection, RelationQuery relationQuery, Field relation) throws SQLException {
        OneToManyRelation<T, ?> oneToManyRelation = this.oneToManyRelations.get(relation);
        if (oneToManyRelation != null) {
            oneToManyRelation.add(bean, connection, relationQuery);
            return;
        }
        ManyToManyRelation<T, ?> manyToManyRelation = this.manyToManyRelations.get(relation);
        if (manyToManyRelation != null) {
            manyToManyRelation.add(bean, connection, relationQuery);
            return;
        }
        OneToOneRelation<T, ?> oneToOneRelation = this.oneToOneRelations.get(relation);
        if (oneToOneRelation != null && !oneToOneRelation.preAdd()) {
            oneToOneRelation.add(bean, connection, relationQuery);
            return;
        }
    }

    private void preUpdateRelations(T bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        if (RelationQuery.hasRelations(relationQuery)) {
            for (Field relation : relationQuery.getRelations()) {
                this.preUpdateRelation(bean, connection, relationQuery, relation);
            }
        }
        if (relationQuery == null || !relationQuery.isDisableAutoRelations()) {
            for (Field relation : this.autoUpdateRelations) {
                if (relationQuery != null && relationQuery != null && (relationQuery.containsRelation(relation) || relationQuery.containsExcludedRelation(relation))) continue;
                this.preUpdateRelation(bean, connection, relationQuery, relation);
            }
        }
    }

    private void preUpdateRelation(T bean, Connection connection, RelationQuery relationQuery, Field relation) throws SQLException {
        ManyToOneRelation<T, ?, ?> manyToOneRelation = this.manyToOneRelations.get(relation);
        if (manyToOneRelation != null) {
            manyToOneRelation.update(bean, connection, relationQuery);
            return;
        }
        manyToOneRelation = this.manyToOneRelationKeys.get(relation);
        if (manyToOneRelation != null) {
            manyToOneRelation.update(bean, connection, relationQuery);
            return;
        }
        OneToOneRelation<T, ?> oneToOneRelation = this.oneToOneRelations.get(relation);
        if (oneToOneRelation != null && oneToOneRelation.preAdd()) {
            oneToOneRelation.update(bean, connection, relationQuery);
            return;
        }
    }

    private void updateRelations(T bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        if (RelationQuery.hasRelations(relationQuery)) {
            for (Field relation : relationQuery.getRelations()) {
                this.updateRelation(bean, connection, relationQuery, relation);
            }
        }
        if (relationQuery == null || !relationQuery.isDisableAutoRelations()) {
            for (Field relation : this.autoUpdateRelations) {
                if (relationQuery != null && (relationQuery.containsRelation(relation) || relationQuery.containsExcludedRelation(relation))) continue;
                this.updateRelation(bean, connection, relationQuery, relation);
            }
        }
    }

    private void updateRelation(T bean, Connection connection, RelationQuery relationQuery, Field relation) throws SQLException {
        OneToManyRelation<T, ?> oneToManyRelation = this.oneToManyRelations.get(relation);
        if (oneToManyRelation != null) {
            oneToManyRelation.update(bean, connection, relationQuery);
            return;
        }
        ManyToManyRelation<T, ?> manyToManyRelation = this.manyToManyRelations.get(relation);
        if (manyToManyRelation != null) {
            manyToManyRelation.update(bean, connection, relationQuery);
            return;
        }
        OneToOneRelation<T, ?> oneToOneRelation = this.oneToOneRelations.get(relation);
        if (oneToOneRelation != null && !oneToOneRelation.preAdd()) {
            oneToOneRelation.update(bean, connection, relationQuery);
            return;
        }
    }

    private void setQueryValues(T bean, PreparedStatementQuery query, RelationQuery relationQuery, IntegerCounter integerCounter, Collection<? extends Column<T, ?>> columns, boolean enableExcludedFields) throws SQLException {
        boolean hasExcludedFields = enableExcludedFields && (RelationQuery.hasExcludedFields(relationQuery) || !this.dontUpdateIfNullCoulumns.isEmpty());
        for (Column<T, ?> column : columns) {
            if (hasExcludedFields && (relationQuery != null && relationQuery.containsExcludedField(column.getBeanField()) || this.dontUpdateIfNullCoulumns.contains(column) && column.getBeanValue(bean) == null)) continue;
            if (column.getQueryParameterPopulator() != null) {
                column.getQueryParameterPopulator().populate(query, integerCounter.increment(), column.getBeanValue(bean));
                continue;
            }
            try {
                column.getQueryMethod().invoke((Object)query, integerCounter.increment(), column.getBeanValue(bean));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setQueryValues(List<T> beans, PreparedStatementQuery query, IntegerCounter integerCounter, Collection<? extends Column<T, ?>> columns, Field excludedField) throws SQLException {
        for (Column<T, ?> column : columns) {
            if (column.getBeanField().equals(excludedField)) continue;
            for (T bean : beans) {
                if (column.getQueryParameterPopulator() != null) {
                    column.getQueryParameterPopulator().populate(query, integerCounter.increment(), column.getBeanValue(bean));
                    continue;
                }
                try {
                    column.getQueryMethod().invoke((Object)query, integerCounter.increment(), column.getBeanValue(bean));
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateAll(Collection<T> beans, RelationQuery relationQuery) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            this.addOrUpdateAll(beans, transactionHandler.getConnection(), relationQuery);
            transactionHandler.commit();
        }
        catch (Throwable throwable) {
            TransactionHandler.autoClose(transactionHandler);
            throw throwable;
        }
        TransactionHandler.autoClose(transactionHandler);
    }

    public void addOrUpdateAll(Collection<T> beans, TransactionHandler transactionHandler, RelationQuery relationQuery) throws SQLException {
        this.addOrUpdateAll(beans, transactionHandler.getConnection(), relationQuery);
    }

    public void addOrUpdateAll(Collection<T> beans, Connection connection, RelationQuery relationQuery) throws SQLException {
        for (T bean : beans) {
            this.addOrUpdate(bean, connection, relationQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdate(T bean, RelationQuery relationQuery) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            this.addOrUpdate(bean, transactionHandler.getConnection(), relationQuery);
            transactionHandler.commit();
        }
        catch (Throwable throwable) {
            TransactionHandler.autoClose(transactionHandler);
            throw throwable;
        }
        TransactionHandler.autoClose(transactionHandler);
    }

    public void addOrUpdate(T bean, TransactionHandler transactionHandler, RelationQuery relationQuery) throws SQLException {
        this.addOrUpdate(bean, transactionHandler.getConnection(), relationQuery);
    }

    public void addOrUpdate(T bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        if (!this.isNewBean(bean, connection)) {
            this.update(bean, connection, relationQuery);
        } else {
            this.add(bean, connection, relationQuery);
        }
    }

    public boolean isNewBean(T bean, Connection connection) throws SQLException {
        if (!this.hasKeysSet(bean)) {
            return true;
        }
        return !this.beanExists(bean, connection);
    }

    public boolean hasKeysSet(T bean) throws SQLException {
        for (Column<T, ?> column : this.simpleKeys) {
            if (column.getBeanValue(bean) != null) continue;
            return false;
        }
        for (Column<T, ?> column : this.manyToOneRelationKeys.values()) {
            if (column.getBeanValue(bean) != null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beanExists(T bean) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            boolean bl = this.beanExists(bean, connection);
            return bl;
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }

    public boolean beanExists(T bean, TransactionHandler transactionHandler) throws SQLException {
        return this.beanExists(bean, transactionHandler.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beanExists(T bean, Connection connection) throws SQLException {
        boolean bl;
        BooleanQuery query = null;
        try {
            query = new BooleanQuery(connection, false, this.checkIfExistsSQL);
            IntegerCounter integerCounter = new IntegerCounter();
            this.setQueryValues(bean, query, null, integerCounter, this.simpleKeys, false);
            this.setQueryValues(bean, query, null, integerCounter, this.manyToOneRelationKeys.values(), false);
            bl = query.executeQuery();
        }
        catch (Throwable throwable) {
            PreparedStatementQuery.autoCloseQuery(query);
            throw throwable;
        }
        PreparedStatementQuery.autoCloseQuery(query);
        return bl;
    }

    public void update(T bean) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            this.update(bean, transactionHandler.getConnection(), null);
            transactionHandler.commit();
        }
        catch (Throwable throwable) {
            TransactionHandler.autoClose(transactionHandler);
            throw throwable;
        }
        TransactionHandler.autoClose(transactionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(T bean, RelationQuery relationQuery) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            this.update(bean, transactionHandler.getConnection(), relationQuery);
            transactionHandler.commit();
        }
        catch (Throwable throwable) {
            TransactionHandler.autoClose(transactionHandler);
            throw throwable;
        }
        TransactionHandler.autoClose(transactionHandler);
    }

    public void update(T bean, TransactionHandler transactionHandler, RelationQuery relationQuery) throws SQLException {
        this.update(bean, transactionHandler.getConnection(), relationQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer update(T bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        UpdateQuery query = null;
        try {
            this.preUpdateRelations(bean, connection, relationQuery);
            query = new UpdateQuery(connection, false, this.generateUpdateSQL(relationQuery, bean));
            IntegerCounter integerCounter = new IntegerCounter();
            this.setQueryValues(bean, query, relationQuery, integerCounter, this.columnMap.values(), true);
            this.setQueryValues(bean, query, null, integerCounter, this.simpleKeys, false);
            this.setQueryValues(bean, query, null, integerCounter, this.manyToOneRelationKeys.values(), false);
            query.executeUpdate();
        }
        catch (Throwable throwable) {
            PreparedStatementQuery.autoCloseQuery(query);
            throw throwable;
        }
        PreparedStatementQuery.autoCloseQuery(query);
        this.updateRelations(bean, connection, relationQuery);
        return query.getAffectedRows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(List<T> beans, RelationQuery relationQuery) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            this.update(beans, transactionHandler.getConnection(), relationQuery);
            transactionHandler.commit();
        }
        catch (Throwable throwable) {
            TransactionHandler.autoClose(transactionHandler);
            throw throwable;
        }
        TransactionHandler.autoClose(transactionHandler);
    }

    public void update(List<T> beans, TransactionHandler transactionHandler, RelationQuery relationQuery) throws SQLException {
        this.update(beans, transactionHandler.getConnection(), relationQuery);
    }

    public void update(List<T> beans, Connection connection, RelationQuery relationQuery) throws SQLException {
        for (T bean : beans) {
            this.update(bean, connection, relationQuery);
        }
    }

    public void update(LowLevelQuery<T> lowLevelQuery) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            this.update(lowLevelQuery, connection);
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }

    public void update(LowLevelQuery<T> lowLevelQuery, TransactionHandler transactionHandler) throws SQLException {
        this.update(lowLevelQuery, transactionHandler.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(LowLevelQuery<T> lowLevelQuery, Connection connection) throws SQLException {
        UpdateQuery query;
        block3: {
            query = null;
            try {
                query = new UpdateQuery(connection, false, lowLevelQuery.getSql());
                this.setCustomQueryParameters(query, lowLevelQuery.getParameters());
                if (lowLevelQuery.getGeneratedKeyCollectors() != null) {
                    query.executeUpdate(lowLevelQuery.getGeneratedKeyCollectors());
                    break block3;
                }
                query.executeUpdate();
            }
            catch (Throwable throwable) {
                PreparedStatementQuery.autoCloseQuery(query);
                throw throwable;
            }
        }
        PreparedStatementQuery.autoCloseQuery(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(LowLevelQuery<T> lowLevelQuery) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            T t = this.get(lowLevelQuery, connection);
            return t;
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }

    public T get(LowLevelQuery<T> lowLevelQuery, TransactionHandler transactionHandler) throws SQLException {
        return this.get(lowLevelQuery, transactionHandler.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(LowLevelQuery<T> lowLevelQuery, Connection connection) throws SQLException {
        BeanResultSetPopulator<T> populator = this.getPopulator(connection, lowLevelQuery);
        ObjectQuery<T> query = null;
        try {
            query = new ObjectQuery<T>(connection, false, lowLevelQuery.getSql(), populator);
            this.setCustomQueryParameters(query, lowLevelQuery.getParameters());
            T bean = query.executeQuery();
            if (bean != null && (RelationQuery.hasRelations(lowLevelQuery) || !this.autoGetRelations.isEmpty())) {
                this.populateRelations(bean, connection, lowLevelQuery);
            }
            T t = bean;
            return t;
        }
        finally {
            PreparedStatementQuery.autoCloseQuery(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(LowLevelQuery<T> lowLevelQuery) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            boolean bl = this.getBoolean(lowLevelQuery, connection);
            return bl;
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }

    public boolean getBoolean(LowLevelQuery<T> lowLevelQuery, TransactionHandler transactionHandler) throws SQLException {
        return this.getBoolean(lowLevelQuery, transactionHandler.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(LowLevelQuery<T> lowLevelQuery, Connection connection) throws SQLException {
        boolean bl;
        BooleanQuery query = null;
        try {
            query = new BooleanQuery(connection, false, lowLevelQuery.getSql());
            this.setCustomQueryParameters(query, lowLevelQuery.getParameters());
            bl = query.executeQuery();
        }
        catch (Throwable throwable) {
            PreparedStatementQuery.autoCloseQuery(query);
            throw throwable;
        }
        PreparedStatementQuery.autoCloseQuery(query);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(HighLevelQuery<T> highLevelQuery) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            T t = this.get(highLevelQuery, connection);
            return t;
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }

    public T get(HighLevelQuery<T> highLevelQuery, TransactionHandler transactionHandler) throws SQLException {
        return this.get(highLevelQuery, transactionHandler.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(HighLevelQuery<T> highLevelQuery, Connection connection) throws SQLException {
        BeanResultSetPopulator<T> populator = this.getPopulator(connection, highLevelQuery);
        ObjectQuery<T> query = null;
        try {
            T bean;
            query = new ObjectQuery<T>(connection, false, this.generateGetSQL(highLevelQuery) + this.getCriterias(highLevelQuery, true, false), populator);
            if (highLevelQuery.getParameters() != null) {
                this.setQueryParameters(query, highLevelQuery, 1);
            }
            if ((bean = query.executeQuery()) != null && (RelationQuery.hasRelations(highLevelQuery) || !this.autoGetRelations.isEmpty())) {
                this.populateRelations(bean, connection, highLevelQuery);
            }
            T t = bean;
            return t;
        }
        finally {
            PreparedStatementQuery.autoCloseQuery(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(HighLevelQuery<T> highLevelQuery) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            boolean bl = this.getBoolean(highLevelQuery, connection);
            return bl;
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }

    public boolean getBoolean(HighLevelQuery<T> highLevelQuery, TransactionHandler transactionHandler) throws SQLException {
        return this.getBoolean(highLevelQuery, transactionHandler.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(HighLevelQuery<T> highLevelQuery, Connection connection) throws SQLException {
        boolean bl;
        BooleanQuery query = null;
        try {
            query = new BooleanQuery(connection, false, this.booleanSQL + this.getCriterias(highLevelQuery, true, false));
            if (highLevelQuery.getParameters() != null) {
                this.setQueryParameters(query, highLevelQuery, 1);
            }
            bl = query.executeQuery();
        }
        catch (Throwable throwable) {
            PreparedStatementQuery.autoCloseQuery(query);
            throw throwable;
        }
        PreparedStatementQuery.autoCloseQuery(query);
        return bl;
    }

    private String getCriterias(HighLevelQuery<T> highLevelQuery, boolean orderBy, boolean rowLimiter) {
        boolean first;
        if (highLevelQuery == null) {
            if (orderBy) {
                return this.defaultSortingCriteria;
            }
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (highLevelQuery.getParameters() != null) {
            first = true;
            for (QueryParameter<T, ?> queryParameter : highLevelQuery.getParameters()) {
                if (first) {
                    stringBuilder.append(" WHERE ");
                    first = false;
                } else {
                    stringBuilder.append(" AND ");
                }
                stringBuilder.append(queryParameter.getColumn().getColumnName() + " " + queryParameter.getOperator());
                if (!queryParameter.hasValues()) continue;
                if (queryParameter.hasMultipleValues()) {
                    stringBuilder.append(" (?");
                    if (queryParameter.getValues().size() > 1) {
                        StringUtils.repeatString(",?", queryParameter.getValues().size() - 1, stringBuilder);
                    }
                    stringBuilder.append(")");
                    continue;
                }
                stringBuilder.append(" ?");
            }
        }
        if (orderBy && highLevelQuery.getOrderByCriterias() != null) {
            first = true;
            for (OrderByCriteria orderByCriteria : highLevelQuery.getOrderByCriterias()) {
                if (first) {
                    stringBuilder.append(" ORDER BY " + orderByCriteria.getColumn().getColumnName() + " " + orderByCriteria.getOrder().toString());
                    first = false;
                    continue;
                }
                stringBuilder.append(", " + orderByCriteria.getColumn().getColumnName() + " " + orderByCriteria.getOrder().toString());
            }
        } else {
            stringBuilder.append(this.defaultSortingCriteria);
        }
        if (rowLimiter && highLevelQuery.getRowLimiter() != null) {
            stringBuilder.append(" ");
            stringBuilder.append(highLevelQuery.getRowLimiter().getLimitSQL());
        }
        return stringBuilder.toString();
    }

    private <ColumnType> Column<T, ? super ColumnType> getColumn(Field field, Class<ColumnType> paramClass) {
        Column<T, ?> column = this.columnMap.get(field);
        if (column == null) {
            throw new RuntimeException("Field " + field.getName() + " not found in  " + this.beanClass + "!");
        }
        if (!column.getParamType().isAssignableFrom(paramClass)) {
            throw new RuntimeException(" " + paramClass + " is not compatible with type " + column.getParamType() + " of field " + field + " in  " + this.beanClass + "!");
        }
        return column;
    }

    protected BeanResultSetPopulator<T> getPopulator(Connection connection, LowLevelQuery<T> query) {
        BeanResultSetPopulator<T> populator = this.getPopulator(connection, (RelationQuery)query);
        if (query.hasChainedBeanResultSetPopulators()) {
            return new BeanChainPopulator<T>(query.getChainedResultSetPopulators(), populator);
        }
        return populator;
    }

    protected BeanResultSetPopulator<T> getPopulator(Connection connection, RelationQuery relationQuery) {
        ManyToOneRelation<T, ?, ?> manyToOneRelation;
        ArrayList manyToOneRelations = null;
        if (RelationQuery.hasRelations(relationQuery)) {
            for (Field relation : relationQuery.getRelations()) {
                manyToOneRelation = this.manyToOneRelations.get(relation);
                if (manyToOneRelation == null) {
                    manyToOneRelation = this.manyToOneRelationKeys.get(relation);
                }
                if (manyToOneRelation == null) continue;
                if (manyToOneRelations == null) {
                    manyToOneRelations = new ArrayList();
                }
                manyToOneRelations.add(manyToOneRelation);
            }
        }
        if (!(this.autoGetRelations.isEmpty() || relationQuery != null && relationQuery.isDisableAutoRelations())) {
            for (Field relation : this.autoGetRelations) {
                if (relationQuery != null && (relationQuery.containsRelation(relation) || relationQuery.containsExcludedRelation(relation))) continue;
                manyToOneRelation = this.manyToOneRelations.get(relation);
                if (manyToOneRelation == null) {
                    manyToOneRelation = this.manyToOneRelationKeys.get(relation);
                }
                if (manyToOneRelation == null) continue;
                if (manyToOneRelations == null) {
                    manyToOneRelations = new ArrayList();
                }
                manyToOneRelations.add(manyToOneRelation);
            }
        }
        if (manyToOneRelations != null) {
            return new BeanRelationPopulator<T>(this.populator, manyToOneRelations, connection, relationQuery);
        }
        return this.populator;
    }

    protected void populateRelations(T bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        if (RelationQuery.hasRelations(relationQuery)) {
            for (Field relation : relationQuery.getRelations()) {
                this.populateRelation(bean, connection, relationQuery, relation);
            }
        }
        if (relationQuery == null || !relationQuery.isDisableAutoRelations()) {
            for (Field relation : this.autoGetRelations) {
                if (relationQuery != null && (relationQuery.containsRelation(relation) || relationQuery.containsExcludedRelation(relation))) continue;
                this.populateRelation(bean, connection, relationQuery, relation);
            }
        }
    }

    protected void populateRelation(T bean, Connection connection, RelationQuery relationQuery, Field relation) throws SQLException {
        OneToManyRelation<T, ?> oneToManyRelation = this.oneToManyRelations.get(relation);
        if (oneToManyRelation != null) {
            oneToManyRelation.getRemoteValue(bean, connection, relationQuery);
            return;
        }
        ManyToManyRelation<T, ?> manyToManyRelation = this.manyToManyRelations.get(relation);
        if (manyToManyRelation != null) {
            manyToManyRelation.getRemoteValue(bean, connection, relationQuery);
            return;
        }
        OneToOneRelation<T, ?> oneToOneRelation = this.oneToOneRelations.get(relation);
        if (oneToOneRelation != null) {
            oneToOneRelation.getRemoteValue(bean, connection, relationQuery);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getAll(LowLevelQuery<T> lowLevelQuery) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            List<T> list = this.getAll(lowLevelQuery, connection);
            return list;
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }

    public List<T> getAll(LowLevelQuery<T> lowLevelQuery, TransactionHandler transactionHandler) throws SQLException {
        return this.getAll(lowLevelQuery, transactionHandler.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getAll(LowLevelQuery<T> lowLevelQuery, Connection connection) throws SQLException {
        BeanResultSetPopulator<T> populator = this.getPopulator(connection, lowLevelQuery);
        ArrayListQuery<T> query = null;
        try {
            query = new ArrayListQuery<T>(connection, false, lowLevelQuery.getSql(), populator);
            this.setCustomQueryParameters(query, lowLevelQuery.getParameters());
            ArrayList<T> beans = query.executeQuery();
            if (beans != null && (RelationQuery.hasRelations(lowLevelQuery) || !this.autoGetRelations.isEmpty())) {
                for (Object bean : beans) {
                    this.populateRelations(bean, connection, lowLevelQuery);
                }
            }
            ArrayList<T> arrayList = beans;
            return arrayList;
        }
        finally {
            PreparedStatementQuery.autoCloseQuery(query);
        }
    }

    private void setCustomQueryParameters(PreparedStatementQuery query, List<?> parameters) {
        if (parameters != null) {
            int i = 1;
            for (Object object : parameters) {
                Method queryMethod;
                if (object == null) {
                    queryMethod = PreparedStatementQueryMethods.getObjectQueryMethod();
                } else if (object.getClass().isEnum()) {
                    object = object.toString();
                    queryMethod = PreparedStatementQueryMethods.getQueryMethod(String.class);
                } else {
                    queryMethod = PreparedStatementQueryMethods.getQueryMethod(object.getClass());
                }
                if (queryMethod == null) {
                    throw new RuntimeException("Unable to find suitable prepared statement query method for parameter " + object.getClass());
                }
                try {
                    queryMethod.invoke((Object)query, i++, object);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<T> getAll(String sql, CustomQueryParameter<?> queryParameter, Connection connection, RelationQuery relationQuery) throws SQLException {
        BeanResultSetPopulator<T> populator = this.getPopulator(connection, relationQuery);
        ArrayListQuery<T> query = null;
        try {
            query = new ArrayListQuery<T>(connection, false, sql, populator);
            if (queryParameter.getQueryParameterPopulator() != null) {
                queryParameter.getQueryParameterPopulator().populate(query, 1, queryParameter.getParamValue());
            } else {
                try {
                    queryParameter.getQueryMethod().invoke(query, 1, queryParameter.getParamValue());
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            ArrayList<T> beans = query.executeQuery();
            if (beans != null && (RelationQuery.hasRelations(relationQuery) || !this.autoGetRelations.isEmpty())) {
                for (Object bean : beans) {
                    this.populateRelations(bean, connection, relationQuery);
                }
            }
            ArrayList<T> arrayList = beans;
            return arrayList;
        }
        finally {
            PreparedStatementQuery.autoCloseQuery(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getAll(HighLevelQuery<T> highLevelQuery) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            List<T> list = this.getAll(highLevelQuery, connection);
            return list;
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }

    public List<T> getAll(HighLevelQuery<T> highLevelQuery, TransactionHandler transactionHandler) throws SQLException {
        return this.getAll(highLevelQuery, transactionHandler.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getAll(HighLevelQuery<T> highLevelQuery, Connection connection) throws SQLException {
        BeanResultSetPopulator<T> populator = this.getPopulator(connection, highLevelQuery);
        ArrayListQuery<T> query = null;
        try {
            query = new ArrayListQuery<T>(connection, false, this.generateGetSQL(highLevelQuery) + this.getCriterias(highLevelQuery, true, true), populator);
            this.setQueryParameters(query, highLevelQuery, 1);
            ArrayList<T> beans = query.executeQuery();
            if (beans != null && (RelationQuery.hasRelations(highLevelQuery) || !this.autoGetRelations.isEmpty())) {
                for (Object bean : beans) {
                    this.populateRelations(bean, connection, highLevelQuery);
                }
            }
            ArrayList<T> arrayList = beans;
            return arrayList;
        }
        finally {
            PreparedStatementQuery.autoCloseQuery(query);
        }
    }

    public List<T> getAll() throws SQLException {
        return this.getAll((HighLevelQuery)null);
    }

    public void delete(T bean) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            this.delete(bean, transactionHandler);
            transactionHandler.commit();
        }
        catch (Throwable throwable) {
            TransactionHandler.autoClose(transactionHandler);
            throw throwable;
        }
        TransactionHandler.autoClose(transactionHandler);
    }

    public void delete(T bean, TransactionHandler transactionHandler) throws SQLException {
        this.delete(bean, transactionHandler.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(T bean, Connection connection) throws SQLException {
        UpdateQuery query = null;
        try {
            query = new UpdateQuery(connection, false, this.deleteSQL);
            IntegerCounter integerCounter = new IntegerCounter();
            this.setQueryValues(bean, query, null, integerCounter, this.simpleKeys, false);
            this.setQueryValues(bean, query, null, integerCounter, this.manyToOneRelationKeys.values(), false);
            query.executeUpdate();
        }
        catch (Throwable throwable) {
            PreparedStatementQuery.autoCloseQuery(query);
            throw throwable;
        }
        PreparedStatementQuery.autoCloseQuery(query);
    }

    public void delete(List<T> beans) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            this.delete(beans, transactionHandler);
            transactionHandler.commit();
        }
        catch (Throwable throwable) {
            TransactionHandler.autoClose(transactionHandler);
            throw throwable;
        }
        TransactionHandler.autoClose(transactionHandler);
    }

    public void delete(List<T> beans, TransactionHandler transactionHandler) throws SQLException {
        this.delete(beans, transactionHandler.getConnection());
    }

    public void delete(List<T> beans, Connection connection) throws SQLException {
        for (T bean : beans) {
            this.delete(bean, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer delete(HighLevelQuery<T> highLevelQuery) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            Integer n = this.delete(highLevelQuery, connection);
            return n;
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }

    public Integer delete(HighLevelQuery<T> highLevelQuery, TransactionHandler transactionHandler) throws SQLException {
        return this.delete(highLevelQuery, transactionHandler.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer delete(HighLevelQuery<T> highLevelQuery, Connection connection) throws SQLException {
        Integer n;
        UpdateQuery query = null;
        try {
            query = new UpdateQuery(connection, false, this.deleteByFieldSQL + this.getCriterias(highLevelQuery, false, false));
            this.setQueryParameters(query, highLevelQuery, 1);
            query.executeUpdate();
            n = query.getAffectedRows();
        }
        catch (Throwable throwable) {
            PreparedStatementQuery.autoCloseQuery(query);
            throw throwable;
        }
        PreparedStatementQuery.autoCloseQuery(query);
        return n;
    }

    public boolean deleteWhereNotIn(List<T> beans, TransactionHandler transactionHandler, Field excludedField, QueryParameter<T, ?> ... queryParameters) throws SQLException {
        return this.deleteWhereNotIn(beans, transactionHandler.getConnection(), excludedField, queryParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteWhereNotIn(List<T> beans, Connection connection, Field excludedField, QueryParameter<T, ?> ... queryParameters) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DELETE FROM ");
        stringBuilder.append(this.tableName);
        stringBuilder.append(" WHERE");
        ArrayList<T> filteredBeans = new ArrayList<T>(beans);
        Iterator<T> iterator = filteredBeans.iterator();
        while (iterator.hasNext()) {
            if (this.hasKeysSet(iterator.next())) continue;
            iterator.remove();
        }
        if (filteredBeans.isEmpty()) {
            return false;
        }
        int beanCount = filteredBeans.size();
        BooleanSignal signal = new BooleanSignal();
        this.generateColumWhereNotInSQL(this.simpleKeys, excludedField, stringBuilder, beanCount, signal);
        this.generateColumWhereNotInSQL(this.manyToOneRelationKeys.values(), excludedField, stringBuilder, beanCount, signal);
        if (queryParameters != null) {
            for (QueryParameter<T, ?> queryParameter : queryParameters) {
                stringBuilder.append(" AND " + queryParameter.getColumn().getColumnName() + " " + queryParameter.getOperator() + " ?");
            }
        }
        UpdateQuery query = null;
        try {
            query = new UpdateQuery(connection, false, stringBuilder.toString());
            IntegerCounter integerCounter = new IntegerCounter();
            this.setQueryValues(filteredBeans, query, integerCounter, this.simpleKeys, excludedField);
            this.setQueryValues(filteredBeans, query, integerCounter, this.manyToOneRelationKeys.values(), excludedField);
            if (queryParameters != null) {
                this.setQueryParameters(query, new HighLevelQuery<T>(queryParameters), integerCounter.increment());
            }
            query.executeUpdate();
        }
        catch (Throwable throwable) {
            PreparedStatementQuery.autoCloseQuery(query);
            throw throwable;
        }
        PreparedStatementQuery.autoCloseQuery(query);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getCount(HighLevelQuery<T> highLevelQuery) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            Integer n = this.getCount(highLevelQuery, connection);
            return n;
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }

    public Integer getCount(HighLevelQuery<T> highLevelQuery, TransactionHandler transactionHandler) throws SQLException {
        return this.getCount(highLevelQuery, transactionHandler.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getCount(HighLevelQuery<T> highLevelQuery, Connection connection) throws SQLException {
        ObjectQuery<Integer> query = null;
        try {
            query = new ObjectQuery<Integer>(connection, false, "SELECT COUNT(*) FROM " + this.tableName + this.getCriterias(highLevelQuery, false, false), (BeanResultSetPopulator<Integer>)IntegerPopulator.getPopulator());
            if (highLevelQuery != null && highLevelQuery.getParameters() != null) {
                this.setQueryParameters(query, highLevelQuery, 1);
            }
            Integer n = query.executeQuery();
            return n;
        }
        finally {
            PreparedStatementQuery.autoCloseQuery(query);
        }
    }

    private void generateColumWhereNotInSQL(Collection<? extends Column<T, ?>> keyColumns, Field excludedField, StringBuilder stringBuilder, int beanCount, BooleanSignal signal) {
        for (Column<T, ?> column : keyColumns) {
            if (column.getBeanField().equals(excludedField)) continue;
            if (signal.isSignal()) {
                stringBuilder.append(" AND");
            } else {
                signal.setSignal(true);
            }
            stringBuilder.append(" ");
            stringBuilder.append(column.getColumnName());
            stringBuilder.append(" NOT IN (");
            this.addQuestionMarks(beanCount, stringBuilder);
            stringBuilder.append(")");
        }
    }

    private void addQuestionMarks(int size, StringBuilder stringBuilder) {
        stringBuilder.append("?");
        if (size > 1) {
            for (int i = 2; i <= size; ++i) {
                stringBuilder.append(",?");
            }
        }
    }

    public <ParamType> QueryParameterFactory<T, ParamType> getParamFactory(Field field, Class<ParamType> paramClass) {
        return new QueryParameterFactory<T, ParamType>(this.getColumn(field, paramClass));
    }

    public <ParamType> QueryParameterFactory<T, ParamType> getParamFactory(String fieldName, Class<ParamType> paramClass) {
        Field field = ReflectionUtils.getField(this.beanClass, fieldName);
        if (field == null) {
            throw new RuntimeException("Field " + fieldName + " not found in  " + this.beanClass + "!");
        }
        return new QueryParameterFactory<T, ParamType>(this.getColumn(field, paramClass));
    }

    public OrderByCriteria<T> getOrderByCriteria(Field field, Order order) {
        Column<T, ?> column = this.columnMap.get(field);
        if (column == null) {
            throw new RuntimeException("No @DAOManaged annotated field with name " + field.getName() + " not found in  " + this.beanClass + "!");
        }
        return new OrderByCriteria<T>(order, column);
    }

    public OrderByCriteria<T> getOrderByCriteria(String fieldName, Order order) {
        Field field = ReflectionUtils.getField(this.beanClass, fieldName);
        if (field == null) {
            throw new RuntimeException("Field " + fieldName + " not found in  " + this.beanClass + "!");
        }
        return this.getOrderByCriteria(field, order);
    }

    public String getTableName() {
        return this.tableName;
    }

    Column<T, ?> getColumn(Field field) {
        return this.columnMap.get(field);
    }

    protected void setQueryParameters(PreparedStatementQuery query, HighLevelQuery<T> highLevelQuery, int startIndex) throws SQLException {
        if (highLevelQuery != null && highLevelQuery.getParameters() != null) {
            int index = startIndex;
            for (QueryParameter<T, ?> queryParameter : highLevelQuery.getParameters()) {
                if (!queryParameter.hasValues()) continue;
                if (queryParameter.hasMultipleValues()) {
                    for (Object value : queryParameter.getValues()) {
                        this.setQueryParameter(queryParameter, value, query, index++);
                    }
                    continue;
                }
                this.setQueryParameter(queryParameter, queryParameter.getValue(), query, index++);
            }
        }
    }

    private void setQueryParameter(QueryParameter<?, ?> queryParameter, Object value, PreparedStatementQuery query, int index) throws SQLException {
        Column<?, ?> column = queryParameter.getColumn();
        if (column.getQueryParameterPopulator() != null) {
            column.getQueryParameterPopulator().populate(query, index, column.getParamValue(value));
        } else {
            try {
                column.getQueryMethod().invoke((Object)query, index, column.getParamValue(value));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    public <KeyType> AnnotatedDAOWrapper<T, KeyType> getWrapper(String keyField, Class<KeyType> keyClass) {
        return new AnnotatedDAOWrapper(this, keyField, keyClass);
    }

    public <KeyType> AnnotatedDAOWrapper<T, KeyType> getWrapper(Class<KeyType> keyClass) {
        return new AnnotatedDAOWrapper(this, this.getFirstKeyField(), keyClass);
    }

    public Field getFirstKeyField() {
        if (!this.simpleKeys.isEmpty()) {
            return this.simpleKeys.get(0).getBeanField();
        }
        if (!this.manyToOneRelationKeys.isEmpty()) {
            return this.manyToOneRelationKeys.get(0).getBeanField();
        }
        throw new RuntimeException("No key field found!");
    }

    public <KeyType> AdvancedAnnotatedDAOWrapper<T, KeyType> getAdvancedWrapper(String keyField, Class<KeyType> keyClass) {
        return new AdvancedAnnotatedDAOWrapper(this, keyField, keyClass);
    }

    public <KeyType> AdvancedAnnotatedDAOWrapper<T, KeyType> getAdvancedWrapper(Class<KeyType> keyClass) {
        return new AdvancedAnnotatedDAOWrapper(this, this.getFirstKeyField(), keyClass);
    }

    public static String getTableName(Class<?> clazz) {
        Table table = clazz.getAnnotation(Table.class);
        if (table == null) {
            throw new RuntimeException("No @" + Table.class.getSimpleName() + " annotation found for " + clazz);
        }
        return table.name();
    }
}

