/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao;

import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.List;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.CRUDDAO;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.dao.RelationQuery;
import se.unlogic.standardutils.dao.TransactionHandler;

public class AdvancedAnnotatedDAOWrapper<BeanType, KeyType>
implements CRUDDAO<BeanType, KeyType> {
    protected AnnotatedDAO<BeanType> annotatedDAO;
    protected QueryParameterFactory<BeanType, KeyType> parameterFactory;
    protected RelationQuery addQuery = new RelationQuery();
    protected RelationQuery updateQuery = new RelationQuery();
    protected HighLevelQuery<BeanType> getQuery = new HighLevelQuery();
    protected HighLevelQuery<BeanType> getAllQuery = new HighLevelQuery();

    public AdvancedAnnotatedDAOWrapper(AnnotatedDAO<BeanType> annotatedDAO, String keyField, Class<KeyType> keyClass) {
        this.annotatedDAO = annotatedDAO;
        this.parameterFactory = annotatedDAO.getParamFactory(keyField, keyClass);
    }

    public AdvancedAnnotatedDAOWrapper(AnnotatedDAO<BeanType> annotatedDAO, Field keyField, Class<KeyType> keyClass) {
        this.annotatedDAO = annotatedDAO;
        this.parameterFactory = annotatedDAO.getParamFactory(keyField, keyClass);
    }

    @Override
    public List<BeanType> getAll() throws SQLException {
        return this.getAll(null);
    }

    @Override
    public List<BeanType> getAll(TransactionHandler transactionHandler) throws SQLException {
        if (transactionHandler != null) {
            return this.annotatedDAO.getAll(this.getAllQuery, transactionHandler);
        }
        return this.annotatedDAO.getAll(this.getAllQuery);
    }

    @Override
    public void add(BeanType bean) throws SQLException {
        this.add(bean, null);
    }

    @Override
    public void add(BeanType bean, TransactionHandler transactionHandler) throws SQLException {
        if (transactionHandler != null) {
            this.annotatedDAO.add(bean, transactionHandler, this.addQuery);
        } else {
            this.annotatedDAO.add(bean, this.addQuery);
        }
    }

    @Override
    public void delete(BeanType bean) throws SQLException {
        this.annotatedDAO.delete(bean);
    }

    @Override
    public void delete(BeanType bean, TransactionHandler transactionHandler) throws SQLException {
        this.annotatedDAO.delete(bean, transactionHandler);
    }

    @Override
    public BeanType get(KeyType beanID) throws SQLException {
        return this.get(beanID, (TransactionHandler)null);
    }

    @Override
    public BeanType get(KeyType beanID, TransactionHandler transactionHandler) throws SQLException {
        RelationQuery query = this.getQuery.clone();
        ((HighLevelQuery)query).addParameter(this.parameterFactory.getParameter(beanID));
        if (transactionHandler != null) {
            return this.annotatedDAO.get((HighLevelQuery<BeanType>)query, transactionHandler);
        }
        return this.annotatedDAO.get((HighLevelQuery<BeanType>)query);
    }

    @Override
    public void update(BeanType bean) throws SQLException {
        this.update(bean, null);
    }

    @Override
    public void update(BeanType bean, TransactionHandler transactionHandler) throws SQLException {
        if (transactionHandler != null) {
            this.annotatedDAO.update(bean, transactionHandler, this.updateQuery);
        } else {
            this.annotatedDAO.update(bean, this.updateQuery);
        }
    }

    public AnnotatedDAO<BeanType> getAnnotatedDAO() {
        return this.annotatedDAO;
    }

    public QueryParameterFactory<BeanType, KeyType> getParameterFactory() {
        return this.parameterFactory;
    }

    public RelationQuery getAddQuery() {
        return this.addQuery;
    }

    public RelationQuery getUpdateQuery() {
        return this.updateQuery;
    }

    public HighLevelQuery<BeanType> getGetQuery() {
        return this.getQuery;
    }

    public HighLevelQuery<BeanType> getGetAllQuery() {
        return this.getAllQuery;
    }

    public TransactionHandler createTransaction() throws SQLException {
        return this.annotatedDAO.createTransaction();
    }
}

