/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.collections;

import java.util.HashMap;
import java.util.Map;
import se.unlogic.standardutils.collections.KeyAlreadyCachedException;
import se.unlogic.standardutils.collections.KeyNotCachedException;
import se.unlogic.standardutils.collections.StrictMap;

public class StrictHashMap<Key, Value>
extends HashMap<Key, Value>
implements StrictMap<Key, Value> {
    private static final long serialVersionUID = 6901384924202372770L;

    @Override
    public Value put(Key key, Value value) throws KeyAlreadyCachedException {
        if (this.containsKey(key)) {
            throw new KeyAlreadyCachedException(key);
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends Key, ? extends Value> map) throws KeyAlreadyCachedException {
        for (Map.Entry<Key, Value> entry : map.entrySet()) {
            if (!this.containsKey(entry.getKey())) continue;
            throw new KeyAlreadyCachedException(entry.getKey());
        }
        super.putAll(map);
    }

    @Override
    public Value remove(Object key) throws KeyNotCachedException {
        if (this.containsKey(key)) {
            return (Value)super.remove(key);
        }
        throw new KeyNotCachedException(key);
    }

    @Override
    public Value update(Key key, Value value) throws KeyNotCachedException {
        if (this.containsKey(key)) {
            super.remove(key);
            return this.put(key, value);
        }
        throw new KeyNotCachedException(key);
    }
}

