/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class CollectionUtils {
    public static <T> List<T> getGenericList(Class<T> clazz, int size) {
        return new ArrayList(size);
    }

    public static <T> List<T> getGenericList(Class<T> clazz) {
        return new ArrayList();
    }

    public static <T> List<T> getGenericSingletonList(T bean) {
        if (bean == null) {
            return null;
        }
        return Collections.singletonList(bean);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <T> List<T> conjunction(Collection<T> c1, Collection<T> c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>(c1.size());
        for (T o : c1) {
            if (!c2.contains(o)) continue;
            result.add(o);
        }
        return result;
    }

    public static <T> Collection<T> exclusiveDisjunction(Collection<T> c1, Collection<T> c2) {
        if (c1 == null && c2 == null) {
            return null;
        }
        if (c1 == null && c2 != null) {
            return c2;
        }
        if (c1 != null && c2 == null) {
            return c1;
        }
        ArrayList<T> result = new ArrayList<T>(c1.size());
        for (T o : c1) {
            if (c2.contains(o)) continue;
            result.add(o);
        }
        return result;
    }

    public static <T> List<T> getList(T ... objects) {
        if (objects == null) {
            return null;
        }
        return Arrays.asList(objects);
    }

    public static void removeNullValues(List<?> list) {
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (value != null) continue;
            iterator.remove();
        }
    }

    public static int getSize(Collection<?> collection) {
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    public static int getSize(Collection<?> ... collections) {
        int size = 0;
        if (collections != null) {
            for (Collection<?> collection : collections) {
                size += CollectionUtils.getSize(collection);
            }
        }
        return size;
    }

    public static <T> ArrayList<T> combine(Collection<T> ... collections) {
        int totalSize = 0;
        for (Collection<T> list : collections) {
            if (CollectionUtils.getSize(list) <= 0) continue;
            totalSize += list.size();
        }
        if (totalSize == 0) {
            return null;
        }
        ArrayList<T> combinedList = new ArrayList<T>(totalSize);
        for (Collection<T> list : collections) {
            if (list == null) continue;
            combinedList.addAll(list);
        }
        return combinedList;
    }

    public static <T> HashSet<T> combineAsSet(Collection<T> ... collections) {
        int totalSize = 0;
        for (Collection<T> list : collections) {
            if (CollectionUtils.getSize(list) <= 0) continue;
            totalSize += list.size();
        }
        if (totalSize == 0) {
            return null;
        }
        HashSet<T> set = new HashSet<T>(totalSize);
        for (Collection<T> list : collections) {
            if (list == null) continue;
            set.addAll(list);
        }
        return set;
    }

    public static <T> void addNewEntries(List<T> list1, List<T> list2) {
        for (T object : list2) {
            if (list1.contains(object)) continue;
            list1.add(object);
        }
    }

    public static <T> List<T> instantiateIfNeeded(List<T> list) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        return list;
    }

    public static <T> List<T> addAndInstantiateIfNeeded(List<T> list, T item) {
        list = CollectionUtils.instantiateIfNeeded(list);
        list.add(item);
        return list;
    }

    public static <T> List<T> addAndInstantiateIfNeeded(List<T> list, List<T> items) {
        list = CollectionUtils.instantiateIfNeeded(list);
        list.addAll(items);
        return list;
    }

    public static <T> List<T> removeDuplicates(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.size() == 1) {
            return list;
        }
        return new ArrayList<T>(new LinkedHashSet<T>(list));
    }

    public static <T> void add(Collection<T> targetCollection, Collection<T> collectionToAdd) {
        if (collectionToAdd != null) {
            targetCollection.addAll(collectionToAdd);
        }
    }

    public static <T> boolean addItem(Collection<? super T> targetCollection, T item) {
        if (item != null) {
            return targetCollection.add(item);
        }
        return false;
    }

    public static <T> boolean equals(List<T> list1, List<T> list2) {
        if (list1 == null) {
            return list2 == null;
        }
        if (list2 == null) {
            return false;
        }
        return list1.equals(list2);
    }

    public static <T extends Comparable<T>> int addInOrder(List<T> list, T item) {
        int index = Collections.binarySearch(list, item);
        int insertAt = index < 0 ? -(index + 1) : index + 1;
        list.add(insertAt, item);
        return insertAt;
    }

    public static <T> int addInOrder(List<T> list, T item, Comparator<? super T> comparator) {
        int index = Collections.binarySearch(list, item, comparator);
        int insertAt = index < 0 ? -(index + 1) : index + 1;
        list.add(insertAt, item);
        return insertAt;
    }
}

