/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.openhierarchy.foregroundmodules.siteprofile;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.annotations.WebPublic;
import se.unlogic.hierarchy.core.beans.Breadcrumb;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.handlers.SimpleSettingHandler;
import se.unlogic.hierarchy.core.interfaces.CachedXSLTDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.core.interfaces.SettingHandler;
import se.unlogic.hierarchy.core.settings.FormElement;
import se.unlogic.hierarchy.core.settings.InvalidFormatException;
import se.unlogic.hierarchy.core.settings.Setting;
import se.unlogic.hierarchy.core.utils.CRUDCallback;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.openhierarchy.foregroundmodules.siteprofile.FallbackSettingHandler;
import se.unlogic.openhierarchy.foregroundmodules.siteprofile.ProfileCRUD;
import se.unlogic.openhierarchy.foregroundmodules.siteprofile.beans.GlobalSettingValue;
import se.unlogic.openhierarchy.foregroundmodules.siteprofile.beans.Profile;
import se.unlogic.openhierarchy.foregroundmodules.siteprofile.beans.ProfileSettingValue;
import se.unlogic.openhierarchy.foregroundmodules.siteprofile.interfaces.SiteProfileHandler;
import se.unlogic.openhierarchy.foregroundmodules.siteprofile.interfaces.SiteProfileSettingProvider;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.CRUDDAO;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.dao.SimpleAnnotatedDAOFactory;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.db.tableversionhandler.DBScriptProvider;
import se.unlogic.standardutils.db.tableversionhandler.TableVersionHandler;
import se.unlogic.standardutils.db.tableversionhandler.UpgradeResult;
import se.unlogic.standardutils.db.tableversionhandler.XMLDBScriptProvider;
import se.unlogic.standardutils.factory.BeanFactory;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationErrorType;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;
import se.unlogic.webutils.url.URLRewriter;

public class SiteProfilesAdminModule
extends AnnotatedForegroundModule
implements SiteProfileHandler,
CRUDCallback<User>,
BeanFactory<GlobalSettingValue> {
    private AnnotatedDAO<GlobalSettingValue> globalSettingValueDAO;
    private AnnotatedDAO<Profile> profileDAO;
    private SettingHandler globalSettingHandler;
    private LinkedHashMap<Integer, Profile> profileIDMap;
    private HashMap<String, Profile> profileDomainMap;
    private HashSet<SiteProfileSettingProvider> settingProviders = new HashSet();
    private QueryParameterFactory<GlobalSettingValue, String> globalSettingIDParamFactory;
    private ProfileCRUD profileCRUD;

    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptor, sectionInterface, dataSource);
        this.cacheGlobalSettings();
        this.cacheProfiles();
        if (!this.systemInterface.getInstanceHandler().addInstance(SiteProfileHandler.class, (Object)this)) {
            throw new RuntimeException("Unable to register module in global instance handler using key " + SiteProfileHandler.class.getSimpleName() + ", another instance is already registered using this key.");
        }
    }

    protected void createDAOs(DataSource dataSource) throws Exception {
        UpgradeResult upgradeResult = TableVersionHandler.upgradeDBTables((DataSource)dataSource, (String)this.getClass().getName(), (DBScriptProvider)new XMLDBScriptProvider(this.getClass().getResourceAsStream("dbscripts/DB script.xml")));
        if (upgradeResult.isUpgrade()) {
            this.log.info((Object)upgradeResult.toString());
        }
        SimpleAnnotatedDAOFactory daoFactory = new SimpleAnnotatedDAOFactory(dataSource);
        this.profileDAO = daoFactory.getDAO(Profile.class);
        this.globalSettingValueDAO = daoFactory.getDAO(GlobalSettingValue.class);
        this.globalSettingIDParamFactory = this.globalSettingValueDAO.getParamFactory("settingID", String.class);
        this.profileCRUD = new ProfileCRUD((CRUDDAO<Profile, Integer>)this.profileDAO.getAdvancedWrapper(Integer.class), this);
    }

    protected void cacheGlobalSettings() throws SQLException {
        List globalSettingValues = this.globalSettingValueDAO.getAll();
        if (globalSettingValues == null) {
            this.globalSettingHandler = new SimpleSettingHandler();
            return;
        }
        HashMap<String, List<String>> settingsMap = SiteProfilesAdminModule.getSettingsToMap(globalSettingValues);
        this.globalSettingHandler = new SimpleSettingHandler(settingsMap);
    }

    protected void cacheProfiles() throws SQLException {
        List profiles = this.profileDAO.getAll();
        if (profiles == null) {
            this.profileIDMap = new LinkedHashMap();
            this.profileDomainMap = new HashMap();
            return;
        }
        LinkedHashMap<Integer, Profile> profileIDMap = new LinkedHashMap<Integer, Profile>();
        HashMap<String, Profile> profileDomainMap = new HashMap<String, Profile>();
        for (Profile profile : profiles) {
            HashMap<Object, Object> settingsMap;
            List<ProfileSettingValue> settingValues = profile.getSettingValues();
            if (settingValues == null) {
                settingsMap = new HashMap();
            } else {
                profile.setSettingValues(null);
                settingsMap = SiteProfilesAdminModule.getSettingsToMap(settingValues);
            }
            profile.setSettingHandler(new FallbackSettingHandler((SettingHandler)new SimpleSettingHandler(settingsMap), this.globalSettingHandler));
            profileIDMap.put(profile.getProfileID(), profile);
            if (profile.getDomains() == null) continue;
            for (String domain : profile.getDomains()) {
                profileDomainMap.put(domain, profile);
            }
        }
        this.profileIDMap = profileIDMap;
        this.profileDomainMap = profileDomainMap;
    }

    protected void moduleConfigured() {
    }

    public void unload() throws Exception {
        if (this.equals(this.systemInterface.getInstanceHandler().getInstance(SiteProfileHandler.class))) {
            this.systemInterface.getInstanceHandler().removeInstance(SiteProfileHandler.class);
        }
        this.settingProviders.clear();
        super.unload();
    }

    public ForegroundModuleResponse defaultMethod(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Throwable {
        return this.profileCRUD.list(req, res, user, uriParser, null);
    }

    @WebPublic(toLowerCase=true)
    public ForegroundModuleResponse addProfile(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.profileCRUD.add(req, res, user, uriParser);
    }

    @WebPublic(toLowerCase=true)
    public ForegroundModuleResponse updateProfile(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.profileCRUD.update(req, res, user, uriParser);
    }

    @WebPublic(toLowerCase=true)
    public ForegroundModuleResponse deleteProfile(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.profileCRUD.delete(req, res, user, uriParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebPublic(alias="globalsettings")
    public ForegroundModuleResponse updateGlobalSettings(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        ArrayList<ValidationError> validationErrors = null;
        if (req.getMethod().equalsIgnoreCase("POST")) {
            validationErrors = new ArrayList<ValidationError>();
            List<GlobalSettingValue> settingValues = this.getSettingValues(req, validationErrors, this, true);
            if (validationErrors.isEmpty()) {
                this.log.info((Object)("User " + user + " updating global settings with " + CollectionUtils.getSize(settingValues) + " values."));
                TransactionHandler transactionHandler = null;
                try {
                    transactionHandler = this.globalSettingValueDAO.createTransaction();
                    this.globalSettingValueDAO.delete((HighLevelQuery)null, transactionHandler);
                    if (settingValues != null) {
                        this.globalSettingValueDAO.addAll(settingValues, transactionHandler, null);
                    }
                    transactionHandler.commit();
                    this.cacheGlobalSettings();
                    this.cacheProfiles();
                    this.redirectToDefaultMethod(req, res);
                }
                finally {
                    TransactionHandler.autoClose((TransactionHandler)transactionHandler);
                }
            }
        }
        this.log.info((Object)("User " + user + " requested update global settings form"));
        Document doc = this.createDocument(req, uriParser, user);
        Element updateGlobalSettingsElement = doc.createElement("UpdateGlobalSettings");
        doc.getFirstChild().appendChild(updateGlobalSettingsElement);
        if (validationErrors != null) {
            updateGlobalSettingsElement.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
            XMLUtils.append((Document)doc, (Element)updateGlobalSettingsElement, (String)"ValidationErrors", validationErrors);
        }
        Set<Setting> settings = this.getProfileSettings();
        XMLUtils.append((Document)doc, (Element)updateGlobalSettingsElement, (String)"SettingDescriptors", settings);
        this.appendSettingHandler(doc, updateGlobalSettingsElement, req, this.globalSettingHandler, settings);
        return new SimpleForegroundModuleResponse(doc, new Breadcrumb[0]);
    }

    @Override
    public boolean addSettingProvider(SiteProfileSettingProvider settingProvider) {
        return this.settingProviders.add(settingProvider);
    }

    @Override
    public boolean removeSettingProvider(SiteProfileSettingProvider settingProvider) {
        return this.settingProviders.remove(settingProvider);
    }

    @Override
    public SettingHandler getGlobalSettingHandler() {
        return this.globalSettingHandler;
    }

    @Override
    public Profile getCurrentProfile(User user, HttpServletRequest req, URIParser uriParser) {
        return this.profileDomainMap.get(req.getServerName());
    }

    @Override
    public SettingHandler getCurrentSettingHandler(User user, HttpServletRequest req, URIParser uriParser) {
        Profile profile = this.getCurrentProfile(user, req, uriParser);
        if (profile != null) {
            return profile.getSettingHandler();
        }
        return this.globalSettingHandler;
    }

    protected static HashMap<String, List<String>> getSettingsToMap(List<? extends GlobalSettingValue> settings) {
        HashMap<String, List<String>> settingMap = new HashMap<String, List<String>>(settings.size());
        List<String> list = null;
        for (GlobalSettingValue globalSettingValue : settings) {
            list = settingMap.get(globalSettingValue.getSettingID());
            if (list == null) {
                list = new ArrayList<String>();
                settingMap.put(globalSettingValue.getSettingID(), list);
            }
            list.add(globalSettingValue.getValue());
        }
        return settingMap;
    }

    public Document createDocument(HttpServletRequest req, URIParser uriParser, User user) {
        Document doc = XMLUtils.createDomDocument();
        Element document = doc.createElement("Document");
        document.appendChild(RequestUtils.getRequestInfoAsXML((Document)doc, (HttpServletRequest)req, (URIParser)uriParser));
        document.appendChild(((ForegroundModuleDescriptor)this.moduleDescriptor).toXML(doc));
        doc.appendChild(document);
        return doc;
    }

    public String getTitlePrefix() {
        return ((ForegroundModuleDescriptor)this.moduleDescriptor).getName();
    }

    @Override
    public Profile getProfile(Integer profileID) {
        return this.profileIDMap.get(profileID);
    }

    public List<Profile> getProfiles() {
        return new ArrayList<Profile>(this.profileIDMap.values());
    }

    public Profile getProfile(String domain) {
        return this.profileDomainMap.get(domain);
    }

    public <T extends GlobalSettingValue> List<T> getSettingValues(HttpServletRequest req, List<ValidationError> validationErrors, BeanFactory<T> factory, boolean checkRequired) {
        Set<Setting> settings = this.getProfileSettings();
        if (settings == null) {
            return null;
        }
        ArrayList<GlobalSettingValue> settingValues = new ArrayList<GlobalSettingValue>(settings.size() * 2);
        block2: for (Setting setting : settings) {
            String[] rawValues = req.getParameterValues("setting-" + setting.getId());
            if (!StringUtils.isEmpty((String[])rawValues) || setting.validateWithoutValues()) {
                try {
                    List parsedValues;
                    if (setting.getFormElement() == FormElement.HTML_EDITOR) {
                        rawValues[0] = URLRewriter.removeAbsoluteLinkUrls((String)rawValues[0], (HttpServletRequest)req);
                    }
                    if ((parsedValues = setting.parseAndValidate(Arrays.asList(rawValues))) == null) {
                        this.log.warn((Object)("Setting " + setting + " returned no values after parsing and validating"));
                        continue;
                    }
                    for (String value : parsedValues) {
                        if (value.length() <= 4096) continue;
                        validationErrors.add(new ValidationError("setting-" + setting.getId(), setting.getName(), ValidationErrorType.TooLong));
                        continue block2;
                    }
                    if (!validationErrors.isEmpty()) continue;
                    int index = 1;
                    for (String value : parsedValues) {
                        GlobalSettingValue settingValue = (GlobalSettingValue)((Object)factory.newInstance());
                        settingValue.setSettingID(setting.getId());
                        settingValue.setValue(value);
                        settingValue.setIndex(index++);
                        settingValues.add(settingValue);
                    }
                    continue;
                }
                catch (InvalidFormatException e) {
                    validationErrors.add(new ValidationError("setting-" + setting.getId(), setting.getName(), ValidationErrorType.InvalidFormat));
                    continue;
                }
            }
            if (!checkRequired || !setting.isRequired()) continue;
            validationErrors.add(new ValidationError("setting-" + setting.getId(), setting.getName(), ValidationErrorType.RequiredField));
        }
        if (settingValues.isEmpty()) {
            return null;
        }
        return settingValues;
    }

    protected Set<Setting> getProfileSettings() {
        LinkedHashSet<Setting> combinedSettings = new LinkedHashSet<Setting>();
        for (SiteProfileSettingProvider settingProvider : this.settingProviders) {
            List<Setting> settingList = settingProvider.getSiteProfileSettings();
            if (settingList == null) continue;
            combinedSettings.addAll(settingList);
        }
        if (combinedSettings.isEmpty()) {
            return null;
        }
        return combinedSettings;
    }

    public GlobalSettingValue newInstance() {
        return new GlobalSettingValue();
    }

    public void appendDesigns(Document doc, Element element) {
        Element designsElement = doc.createElement("Designs");
        element.appendChild(designsElement);
        Collection cachedXSLTDescriptors = this.systemInterface.getCoreXSLTCacheHandler().getCachedXSLTDescriptors(this.systemInterface.getDefaultLanguage());
        for (CachedXSLTDescriptor cachedXSLTDescriptor : cachedXSLTDescriptors) {
            Element designElement = doc.createElement("Design");
            XMLUtils.appendNewElement((Document)doc, (Element)designElement, (String)"name", (String)cachedXSLTDescriptor.getName());
            designsElement.appendChild(designElement);
        }
    }

    public void appendSettingHandler(Document doc, Element targetElement, HttpServletRequest req, SettingHandler settingHandler, Set<Setting> settings) {
        if (settings != null) {
            Element settingsElement = doc.createElement("settings");
            targetElement.appendChild(settingsElement);
            for (Setting setting : settings) {
                List values = settingHandler.getStrings(setting.getId());
                if (values == null) continue;
                Element settingElement = doc.createElement("setting");
                settingsElement.appendChild(settingElement);
                XMLUtils.appendNewElement((Document)doc, (Element)settingElement, (String)"id", (String)setting.getId());
                if (setting.getFormElement() == FormElement.HTML_EDITOR) {
                    XMLUtils.appendNewElement((Document)doc, (Element)settingElement, (String)"value", (String)URLRewriter.setAbsoluteLinkUrls((String)((String)values.get(0)), (HttpServletRequest)req));
                    continue;
                }
                for (String value : values) {
                    settingElement.appendChild(XMLUtils.createCDATAElement((String)"value", (Object)value, (Document)doc));
                }
            }
        }
    }

    @Override
    public void ensureGlobalSettingValues(List<Setting> settings) throws SQLException {
        if (settings != null) {
            this.log.info((Object)("Ensuring global setting values for " + CollectionUtils.getSize(settings) + " settings"));
            ArrayList<GlobalSettingValue> settingValues = new ArrayList<GlobalSettingValue>();
            for (Setting setting : settings) {
                if (!setting.isRequired() || CollectionUtils.isEmpty((Collection)setting.getDefaultValues())) continue;
                HighLevelQuery query = new HighLevelQuery();
                query.addParameter(this.globalSettingIDParamFactory.getParameter((Object)setting.getId()));
                if (this.globalSettingValueDAO.getAll(query) != null) continue;
                int index = 1;
                for (String value : setting.getDefaultValues()) {
                    GlobalSettingValue settingValue = new GlobalSettingValue();
                    settingValue.setSettingID(setting.getId());
                    settingValue.setValue(value);
                    settingValue.setIndex(index++);
                    settingValues.add(settingValue);
                }
            }
            if (!settingValues.isEmpty()) {
                this.globalSettingValueDAO.addAll(settingValues, null);
                this.cacheGlobalSettings();
                this.cacheProfiles();
            }
        }
    }
}

