/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.openhierarchy.foregroundmodules.siteprofile;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.exceptions.AccessDeniedException;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.core.settings.Setting;
import se.unlogic.hierarchy.core.utils.CRUDCallback;
import se.unlogic.hierarchy.core.utils.IntegerBasedCRUD;
import se.unlogic.openhierarchy.foregroundmodules.siteprofile.SiteProfilesAdminModule;
import se.unlogic.openhierarchy.foregroundmodules.siteprofile.beans.Profile;
import se.unlogic.openhierarchy.foregroundmodules.siteprofile.beans.ProfileSettingValue;
import se.unlogic.openhierarchy.foregroundmodules.siteprofile.validationerrors.DomainAlreadyInUseValidationError;
import se.unlogic.standardutils.dao.CRUDDAO;
import se.unlogic.standardutils.factory.BeanFactory;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.Elementable;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.URIParser;
import se.unlogic.webutils.populators.annotated.AnnotatedRequestPopulator;

public class ProfileCRUD
extends IntegerBasedCRUD<Profile, SiteProfilesAdminModule>
implements BeanFactory<ProfileSettingValue> {
    private static final AnnotatedRequestPopulator<Profile> POPULATOR = new AnnotatedRequestPopulator(Profile.class);

    public ProfileCRUD(CRUDDAO<Profile, Integer> crudDAO, SiteProfilesAdminModule callback) {
        super(crudDAO, POPULATOR, "Profile", "profile", "", (CRUDCallback)callback);
    }

    public Profile getBean(Integer beanID, String getMode) throws SQLException, AccessDeniedException {
        if (getMode != null && getMode == "show") {
            return ((SiteProfilesAdminModule)this.callback).getProfile(beanID);
        }
        return (Profile)super.getBean(beanID, getMode);
    }

    protected List<Profile> getAllBeans(User user) throws SQLException {
        return ((SiteProfilesAdminModule)this.callback).getProfiles();
    }

    protected void validateAddPopulation(Profile bean, HttpServletRequest req, User user, URIParser uriParser) throws ValidationException, SQLException, Exception {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (bean.getDomains() != null) {
            for (String domain : bean.getDomains()) {
                Profile profile = ((SiteProfilesAdminModule)this.callback).getProfile(domain);
                if (profile == null || profile.equals(bean)) continue;
                validationErrors.add(new DomainAlreadyInUseValidationError(domain, profile.getName()));
            }
        }
        bean.setSettingValues(((SiteProfilesAdminModule)this.callback).getSettingValues(req, validationErrors, this, false));
        if (!validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
    }

    protected void validateUpdatePopulation(Profile bean, HttpServletRequest req, User user, URIParser uriParser) throws ValidationException, SQLException, Exception {
        this.validateAddPopulation(bean, req, user, uriParser);
    }

    protected String getBeanName(Profile bean) {
        return bean.getName();
    }

    public ProfileSettingValue newInstance() {
        return new ProfileSettingValue();
    }

    protected void appendAddFormData(Document doc, Element addTypeElement, User user, HttpServletRequest req, URIParser uriParser) throws Exception {
        Set<Setting> settings = ((SiteProfilesAdminModule)this.callback).getProfileSettings();
        XMLUtils.append((Document)doc, (Element)addTypeElement, (String)"SettingDescriptors", settings);
        ((SiteProfilesAdminModule)this.callback).appendSettingHandler(doc, addTypeElement, req, ((SiteProfilesAdminModule)this.callback).getGlobalSettingHandler(), settings);
        ((SiteProfilesAdminModule)this.callback).appendDesigns(doc, addTypeElement);
    }

    protected void appendUpdateFormData(Profile bean, Document doc, Element updateTypeElement, User user, HttpServletRequest req, URIParser uriParser) throws Exception {
        Set<Setting> settings = ((SiteProfilesAdminModule)this.callback).getProfileSettings();
        XMLUtils.append((Document)doc, (Element)updateTypeElement, (String)"SettingDescriptors", settings);
        ((SiteProfilesAdminModule)this.callback).appendSettingHandler(doc, updateTypeElement, req, ((SiteProfilesAdminModule)this.callback).getProfile(bean.getProfileID()).getSettingHandler(), settings);
        ((SiteProfilesAdminModule)this.callback).appendDesigns(doc, updateTypeElement);
    }

    protected ForegroundModuleResponse beanAdded(Profile bean, HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        ((SiteProfilesAdminModule)this.callback).cacheProfiles();
        return super.beanAdded((Elementable)bean, req, res, user, uriParser);
    }

    protected ForegroundModuleResponse beanUpdated(Profile bean, HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        ((SiteProfilesAdminModule)this.callback).cacheProfiles();
        return super.beanUpdated((Elementable)bean, req, res, user, uriParser);
    }

    protected ForegroundModuleResponse beanDeleted(Profile bean, HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        ((SiteProfilesAdminModule)this.callback).cacheProfiles();
        return super.beanDeleted((Elementable)bean, req, res, user, uriParser);
    }
}

