/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.openhierarchy.foregroundmodules.siteprofile;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.interfaces.SettingHandler;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.xml.XMLUtils;

public class FallbackSettingHandler
implements SettingHandler {
    private final SettingHandler primary;
    private final SettingHandler fallback;

    public FallbackSettingHandler(SettingHandler primary, SettingHandler fallback) {
        this.primary = primary;
        this.fallback = fallback;
    }

    public boolean isSet(String id) {
        if (this.primary.isSet(id)) {
            return true;
        }
        return this.fallback.isSet(id);
    }

    public String getString(String id) {
        if (!this.primary.isSet(id)) {
            return this.fallback.getString(id);
        }
        return this.primary.getString(id);
    }

    public Integer getInt(String id) {
        if (!this.primary.isSet(id)) {
            return this.fallback.getInt(id);
        }
        return this.primary.getInt(id);
    }

    public Long getLong(String id) {
        if (!this.primary.isSet(id)) {
            return this.fallback.getLong(id);
        }
        return this.primary.getLong(id);
    }

    public Double getDouble(String id) {
        if (!this.primary.isSet(id)) {
            return this.fallback.getDouble(id);
        }
        return this.primary.getDouble(id);
    }

    public Boolean getBoolean(String id) {
        if (!this.primary.isSet(id)) {
            return this.fallback.getBoolean(id);
        }
        return this.primary.getBoolean(id);
    }

    public Set<String> getIDs() {
        return CollectionUtils.combineAsSet((Collection[])new Collection[]{this.primary.getIDs(), this.fallback.getIDs()});
    }

    public List<Double> getDoubles(String id) {
        if (!this.primary.isSet(id)) {
            return this.fallback.getDoubles(id);
        }
        return this.primary.getDoubles(id);
    }

    public List<Integer> getInts(String id) {
        if (!this.primary.isSet(id)) {
            return this.fallback.getInts(id);
        }
        return this.primary.getInts(id);
    }

    public List<Long> getLongs(String id) {
        if (!this.primary.isSet(id)) {
            return this.fallback.getLongs(id);
        }
        return this.primary.getLongs(id);
    }

    public List<String> getStrings(String id) {
        if (!this.primary.isSet(id)) {
            return this.fallback.getStrings(id);
        }
        return this.primary.getStrings(id);
    }

    public boolean getPrimitiveBoolean(String id) {
        if (!this.primary.isSet(id)) {
            return this.fallback.getPrimitiveBoolean(id);
        }
        return this.primary.getPrimitiveBoolean(id);
    }

    public boolean isEmpty() {
        return this.primary.isEmpty() && this.fallback.isEmpty();
    }

    public int size() {
        return this.getIDs().size();
    }

    public Map<String, List<String>> getMap() {
        HashMap<String, List<String>> combinedMap = new HashMap<String, List<String>>(this.fallback.size() + this.primary.size());
        for (Map.Entry entry : this.fallback.getMap().entrySet()) {
            if (this.primary.isSet((String)entry.getKey())) continue;
            combinedMap.put((String)entry.getKey(), (List<String>)entry.getValue());
        }
        combinedMap.putAll(this.primary.getMap());
        return combinedMap;
    }

    public Element toXML(Document doc) {
        Element settingsElement = doc.createElement("settings");
        for (Map.Entry<String, List<String>> entry : this.getMap().entrySet()) {
            Element settingElement = doc.createElement("setting");
            settingsElement.appendChild(settingElement);
            settingElement.appendChild(XMLUtils.createCDATAElement((String)"id", (Object)entry.getKey(), (Document)doc));
            if (entry.getValue() == null) continue;
            for (String value : entry.getValue()) {
                settingElement.appendChild(XMLUtils.createCDATAElement((String)"value", (Object)value, (Document)doc));
            }
        }
        return settingsElement;
    }

    public Short getShort(String id) {
        if (!this.primary.isSet(id)) {
            return this.fallback.getShort(id);
        }
        return this.primary.getShort(id);
    }

    public Float getFloat(String id) {
        if (!this.primary.isSet(id)) {
            return this.fallback.getFloat(id);
        }
        return this.primary.getFloat(id);
    }

    public List<Float> getFloats(String id) {
        if (!this.primary.isSet(id)) {
            return this.fallback.getFloats(id);
        }
        return this.primary.getFloats(id);
    }
}

