package se.unlogic.openhierarchy.foregroundmodules.siteprofile.beans;

import java.util.List;

import se.unlogic.hierarchy.core.interfaces.SettingHandler;
import se.unlogic.openhierarchy.foregroundmodules.siteprofile.interfaces.SiteProfile;
import se.unlogic.standardutils.annotations.SplitOnLineBreak;
import se.unlogic.standardutils.annotations.WebPopulate;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.Key;
import se.unlogic.standardutils.dao.annotations.OneToMany;
import se.unlogic.standardutils.dao.annotations.OrderBy;
import se.unlogic.standardutils.dao.annotations.SimplifiedRelation;
import se.unlogic.standardutils.dao.annotations.Table;
import se.unlogic.standardutils.xml.GeneratedElementable;
import se.unlogic.standardutils.xml.XMLElement;

@Table(name = "site_profiles")
@XMLElement
public class Profile extends GeneratedElementable implements SiteProfile {

	private static final long serialVersionUID = -7417178058150709373L;

	@DAOManaged(autoGenerated=true)
	@Key
	@XMLElement
	private Integer profileID;

	@DAOManaged
	@OrderBy
	@WebPopulate(required = true, maxLength = 255)
	@XMLElement
	private String name;

	@DAOManaged
	@WebPopulate(maxLength = 255)
	@SplitOnLineBreak
	@OneToMany(autoAdd = true, autoGet = true, autoUpdate = true)
	@SimplifiedRelation(table = "site_profile_domains", remoteKeyColumnName = "profileID", remoteValueColumnName = "domain")
	@XMLElement(childName = "domain")
	private List<String> domains;

	@DAOManaged
	@WebPopulate(maxLength = 255)
	@XMLElement
	private String design;

	@DAOManaged
	@OneToMany(autoAdd = true, autoGet = true, autoUpdate = true)
	private List<ProfileSettingValue> settingValues;

	private SettingHandler settingHandler;

	@Override
	public Integer getProfileID() {

		return profileID;
	}

	public void setProfileID(Integer profileID) {

		this.profileID = profileID;
	}

	@Override
	public String getName() {

		return name;
	}

	public void setName(String name) {

		this.name = name;
	}

	@Override
	public List<String> getDomains() {

		return domains;
	}

	public void setDomains(List<String> domains) {

		this.domains = domains;
	}

	@Override
	public String getDesign() {

		return design;
	}

	public void setDesign(String design) {

		this.design = design;
	}

	public List<ProfileSettingValue> getSettingValues() {

		return settingValues;
	}

	public void setSettingValues(List<ProfileSettingValue> profileSettingValues) {

		this.settingValues = profileSettingValues;
	}

	@Override
	public SettingHandler getSettingHandler() {

		return settingHandler;
	}

	public void setSettingHandler(SettingHandler settingHandler) {

		this.settingHandler = settingHandler;
	}

	@Override
	public int hashCode() {

		final int prime = 31;
		int result = 1;
		result = prime * result + ((profileID == null) ? 0 : profileID.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {

		if(this == obj){
			return true;
		}
		if(obj == null){
			return false;
		}
		if(getClass() != obj.getClass()){
			return false;
		}
		Profile other = (Profile)obj;
		if(profileID == null){
			if(other.profileID != null){
				return false;
			}
		}else if(!profileID.equals(other.profileID)){
			return false;
		}
		return true;
	}

	@Override
	public String toString(){

		return name + " (profileID: " + profileID + ")";
	}
}
