/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.purecaptcha.wordrenderers;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.util.Random;
import se.unlogic.purecaptcha.wordrenderers.WordRenderer;

public class DefaultWordRenderer
implements WordRenderer {
    protected Font[] fonts;
    protected Color color;

    public DefaultWordRenderer(Font[] fonts, Color color) {
        this.fonts = fonts;
        this.color = color;
    }

    @Override
    public BufferedImage renderWord(String word, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2D = image.createGraphics();
        g2D.setColor(this.color);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        g2D.setRenderingHints(hints);
        FontRenderContext frc = g2D.getFontRenderContext();
        Random random = new Random();
        int startPosX = width / (2 + word.length());
        int startPosY = (height - this.fonts[0].getSize()) / 5 + this.fonts[0].getSize();
        char[] wordChars = word.toCharArray();
        for (int i = 0; i < wordChars.length; ++i) {
            Font chosenFont = this.fonts[random.nextInt(this.fonts.length)];
            g2D.setFont(chosenFont);
            char[] charToDraw = new char[]{wordChars[i]};
            GlyphVector gv = chosenFont.createGlyphVector(frc, charToDraw);
            double charWidth = gv.getVisualBounds().getWidth();
            g2D.drawChars(charToDraw, 0, charToDraw.length, startPosX, startPosY);
            startPosX = startPosX + (int)charWidth + 2;
        }
        return image;
    }

    public static Font[] getDefaultFonts(int size) {
        return new Font[]{new Font("Arial", 1, size), new Font("Courier", 1, size)};
    }

    public static Font[] getJavaDefaultFonts(int size) {
        return new Font[]{new Font("Serif", 1, size), new Font("SansSerif", 1, size), new Font("SansSerif", 1, size), new Font("DialogInput", 1, size)};
    }
}

