/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.purecaptcha;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import se.unlogic.purecaptcha.Captcha;
import se.unlogic.purecaptcha.CaptchaCode;
import se.unlogic.purecaptcha.CaptchaImage;

public class CaptchaHandler {
    protected Captcha captcha;
    protected String sessionAttribute;
    protected long validationTimeout;
    protected boolean caseSensitive;

    public CaptchaHandler(Captcha captcha, String sessionAttribute, long validationTimeout, boolean caseSensitive) {
        this.captcha = captcha;
        this.sessionAttribute = sessionAttribute;
        this.validationTimeout = validationTimeout;
        this.caseSensitive = caseSensitive;
    }

    public void getCaptchaImage(HttpServletRequest req, HttpServletResponse res) {
        try {
            CaptchaImage captchaImage = this.captcha.generateCaptchaImage();
            req.getSession(true).setAttribute(this.sessionAttribute, (Object)new CaptchaCode(captchaImage.getCode()));
            res.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, proxy-revalidate");
            res.setHeader("Pragma", "no-cache");
            res.setDateHeader("Expires", 0L);
            res.setContentType("image/jpeg");
            ImageIO.write((RenderedImage)captchaImage.getBufferedImage(), "jpg", (OutputStream)res.getOutputStream());
            res.getOutputStream().flush();
            res.getOutputStream().close();
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (SocketException e) {
            return;
        }
        catch (IOException e) {
            return;
        }
        catch (IllegalStateException e) {
            return;
        }
    }

    public boolean isValidCode(HttpServletRequest req, String code) {
        try {
            HttpSession session = req.getSession();
            if (session == null) {
                return false;
            }
            CaptchaCode captchaCode = (CaptchaCode)session.getAttribute(this.sessionAttribute);
            if (captchaCode == null) {
                return false;
            }
            session.removeAttribute(this.sessionAttribute);
            if (captchaCode.getTimestamp() < System.currentTimeMillis() - this.validationTimeout) {
                return false;
            }
            if (this.caseSensitive && captchaCode.getCode().equals(code)) {
                return true;
            }
            if (!this.caseSensitive && captchaCode.getCode().equalsIgnoreCase(code)) {
                return true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return false;
    }
}

